/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.integration;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.api.ChannelAPI;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import org.bukkit.entity.Player;

public class DiscordSRVIntegration {
    private final Nonchat plugin;

    public DiscordSRVIntegration(Nonchat plugin) {
        this.plugin = plugin;
        DiscordSRV.api.subscribe((Object)this);
    }

    public void unregister() {
        DiscordSRV.api.unsubscribe((Object)this);
    }

    @Subscribe
    public void onGameChatMessagePreProcess(GameChatMessagePreProcessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        Channel playerChannel = ChannelAPI.getPlayerChannel(player);
        for (Channel channel : ChannelAPI.getAllChannels()) {
            if (!channel.hasTriggerCharacter() || !message.startsWith(String.valueOf(channel.getCharacter()))) continue;
            if (!channel.getId().equals(event.getChannel())) {
                event.setCancelled(true);
            } else {
                String cleanMessage = message.substring(1);
                event.setMessage(cleanMessage);
            }
            return;
        }
        if (playerChannel != null && !playerChannel.getId().equals(event.getChannel())) {
            event.setCancelled(true);
        }
    }

    @Subscribe
    public void onDiscordGuildMessagePreProcess(DiscordGuildMessagePreProcessEvent event) {
    }
}

