/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.chat.channel.ChannelManager;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.util.chat.packets.DisplayEntityUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinQuitListener
implements Listener {
    private final PluginConfig config;
    private final ChannelManager channelManager;
    private final Map<Player, List<TextDisplay>> bubbles = new HashMap<Player, List<TextDisplay>>();

    public JoinQuitListener(PluginConfig config, ChannelManager channelManager) {
        this.config = config;
        this.channelManager = channelManager;
    }

    private String cleanSoundName(String soundName) {
        if (soundName == null) {
            return "entity.experience_orb.pickup";
        }
        String cleaned = soundName.replace("minecraft:", "");
        cleaned = cleaned.toLowerCase().replace('_', '.');
        return cleaned;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.isJoinMessageEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String joinFormat = this.config.getJoinFormat();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                joinFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)joinFormat);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing join message placeholders: {0}", e.getMessage());
            }
        }
        event.joinMessage(ColorUtil.parseComponent(joinFormat));
        if (this.config.isJoinSoundEnabled()) {
            try {
                String soundName = this.cleanSoundName(this.config.getJoinSound());
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.playSound(onlinePlayer.getLocation(), soundName, this.config.getJoinSoundVolume(), this.config.getJoinSoundPitch());
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error playing join sound: {0}", e.getMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        List<TextDisplay> playerBubbles;
        Player player = event.getPlayer();
        if (this.channelManager != null) {
            this.channelManager.cleanupPlayer(player);
        }
        if ((playerBubbles = this.bubbles.remove(player)) != null) {
            DisplayEntityUtil.removeBubbles(playerBubbles);
        }
        if (!this.config.isQuitMessageEnabled()) {
            return;
        }
        String quitFormat = this.config.getQuitFormat();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                quitFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)quitFormat);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing quit message placeholders: {0}", e.getMessage());
            }
        }
        event.quitMessage(ColorUtil.parseComponent(quitFormat));
        if (this.config.isQuitSoundEnabled()) {
            try {
                String soundName = this.cleanSoundName(this.config.getQuitSound());
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.playSound(onlinePlayer.getLocation(), soundName, this.config.getQuitSoundVolume(), this.config.getQuitSoundPitch());
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error playing quit sound: {0}", e.getMessage());
            }
        }
    }
}

