/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.listener;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.core.ChatManager;
import com.nonxedy.nonchat.listener.ChatListener;
import com.nonxedy.nonchat.service.ChatService;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class PaperChatListener
extends ChatListener {
    private final Nonchat plugin;

    public PaperChatListener(Nonchat plugin, ChatManager chatManager, ChatService chatService) {
        super(chatManager, chatService);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAsyncChat(AsyncChatEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        String message = PlainTextComponentSerializer.plainText().serialize(event.message());
        CompletableFuture.runAsync(() -> {
            try {
                if (this.chatService != null) {
                    this.chatService.handleChat(player, message);
                } else if (this.chatManager != null) {
                    this.chatManager.processChat(player, message);
                }
            }
            catch (Exception e) {
                this.plugin.logError("Async chat processing failed: " + e.getMessage());
            }
        });
    }
}

