/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import lombok.Generated;

public class CapsFilter {
    private final boolean enabled;
    private final int maxCapsPercentage;
    private final int minLength;

    public boolean shouldFilter(String message) {
        if (!this.enabled) {
            return false;
        }
        if (message.length() < this.minLength) {
            return false;
        }
        int capsCount = 0;
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                ++capsCount;
            }
            ++n2;
        }
        double percentage = (double)capsCount / (double)message.length() * 100.0;
        return percentage > (double)this.maxCapsPercentage;
    }

    public String filterMessage(String message) {
        return message.toLowerCase();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxCapsPercentage() {
        return this.maxCapsPercentage;
    }

    public int getMinLength() {
        return this.minLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CapsFilter)) {
            return false;
        }
        CapsFilter other = (CapsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxCapsPercentage() != other.getMaxCapsPercentage()) {
            return false;
        }
        return this.getMinLength() == other.getMinLength();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CapsFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxCapsPercentage();
        result = result * 59 + this.getMinLength();
        return result;
    }

    @Generated
    public String toString() {
        return "CapsFilter(enabled=" + this.isEnabled() + ", maxCapsPercentage=" + this.getMaxCapsPercentage() + ", minLength=" + this.getMinLength() + ")";
    }

    @Generated
    public CapsFilter(boolean enabled, int maxCapsPercentage, int minLength) {
        this.enabled = enabled;
        this.maxCapsPercentage = maxCapsPercentage;
        this.minLength = minLength;
    }
}

