/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.filters;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;

public class WordBlocker {
    private List<String> bannedWords;
    private List<String> bannedPatterns;

    public boolean isMessageAllowed(String message) {
        String lowerMessage = message.toLowerCase();
        for (String word : this.bannedWords) {
            if (!lowerMessage.contains(word.toLowerCase())) continue;
            return false;
        }
        for (String pattern : this.bannedPatterns) {
            try {
                Pattern regex = Pattern.compile(pattern, 2);
                if (!regex.matcher(message).find()) continue;
                return false;
            }
            catch (PatternSyntaxException e) {
                System.err.println("Invalid regex pattern in banned patterns: " + pattern);
            }
        }
        return true;
    }

    public boolean isMessageAllowedLegacy(String message) {
        for (String word : this.bannedWords) {
            if (!message.toLowerCase().contains(word.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    @Generated
    public List<String> getBannedWords() {
        return this.bannedWords;
    }

    @Generated
    public List<String> getBannedPatterns() {
        return this.bannedPatterns;
    }

    @Generated
    public void setBannedWords(List<String> bannedWords) {
        this.bannedWords = bannedWords;
    }

    @Generated
    public void setBannedPatterns(List<String> bannedPatterns) {
        this.bannedPatterns = bannedPatterns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordBlocker)) {
            return false;
        }
        WordBlocker other = (WordBlocker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$bannedWords = this.getBannedWords();
        List<String> other$bannedWords = other.getBannedWords();
        if (this$bannedWords == null ? other$bannedWords != null : !((Object)this$bannedWords).equals(other$bannedWords)) {
            return false;
        }
        List<String> this$bannedPatterns = this.getBannedPatterns();
        List<String> other$bannedPatterns = other.getBannedPatterns();
        return !(this$bannedPatterns == null ? other$bannedPatterns != null : !((Object)this$bannedPatterns).equals(other$bannedPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WordBlocker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $bannedWords = this.getBannedWords();
        result = result * 59 + ($bannedWords == null ? 43 : ((Object)$bannedWords).hashCode());
        List<String> $bannedPatterns = this.getBannedPatterns();
        result = result * 59 + ($bannedPatterns == null ? 43 : ((Object)$bannedPatterns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WordBlocker(bannedWords=" + String.valueOf(this.getBannedWords()) + ", bannedPatterns=" + String.valueOf(this.getBannedPatterns()) + ")";
    }

    @Generated
    public WordBlocker(List<String> bannedWords, List<String> bannedPatterns) {
        this.bannedWords = bannedWords;
        this.bannedPatterns = bannedPatterns;
    }
}

