/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.lang;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final File langsFolder;
    private FileConfiguration currentLang;
    private final Map<String, FileConfiguration> loadedLanguages;

    public LanguageManager(File dataFolder) {
        this.langsFolder = new File(dataFolder, "langs");
        this.loadedLanguages = new HashMap<String, FileConfiguration>();
        this.setupLanguages();
    }

    private void setupLanguages() {
        if (!this.langsFolder.exists()) {
            this.langsFolder.mkdirs();
        }
        this.createLanguageFile("messages_en.yml");
        this.createLanguageFile("messages_ru.yml");
        this.createLanguageFile("messages_es.yml");
        File[] fileArray = this.langsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith("messages_") && file.getName().endsWith(".yml")) {
                String langCode = file.getName().replace("messages_", "").replace(".yml", "");
                this.loadedLanguages.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            }
            ++n2;
        }
    }

    private void createLanguageFile(String filename) {
        File langFile = new File(this.langsFolder, filename);
        if (!langFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream in = this.getClass().getResourceAsStream("/langs/" + filename);){
                    Files.copy(in, langFile.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to create language file: {0}", e.getMessage());
            }
        }
    }

    public void setLanguage(String lang) {
        this.currentLang = this.loadedLanguages.getOrDefault(lang, this.loadedLanguages.get("en"));
    }

    public void reload() {
        this.loadedLanguages.clear();
        File[] fileArray = this.langsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith("messages_") && file.getName().endsWith(".yml")) {
                String langCode = file.getName().replace("messages_", "").replace(".yml", "");
                this.loadedLanguages.put(langCode, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            }
            ++n2;
        }
        if (this.currentLang != null) {
            String currentLangCode = null;
            for (Map.Entry<String, FileConfiguration> entry : this.loadedLanguages.entrySet()) {
                if (entry.getValue() != this.currentLang) continue;
                currentLangCode = entry.getKey();
                break;
            }
            if (currentLangCode != null) {
                this.setLanguage(currentLangCode);
            } else if (!this.loadedLanguages.isEmpty()) {
                this.setLanguage(this.loadedLanguages.containsKey("en") ? "en" : this.loadedLanguages.keySet().iterator().next());
            }
        }
    }

    public String getMessage(String key) {
        return ColorUtil.parseColor(this.currentLang.getString(key, "Missing message: " + key));
    }
}

