/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.special.ping;

import com.nonxedy.nonchat.Nonchat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PingDetector {
    private static final Pattern PING_PATTERN = Pattern.compile("\\[ping\\]", 2);

    /*
     * WARNING - void declaration
     */
    public static Component processPingPlaceholders(Player player, String text) {
        void nonchatPlugin;
        if (text == null || text.isEmpty()) {
            return Component.text((String)text);
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("nonchat");
        if (!(plugin instanceof Nonchat)) {
            return Component.text((String)text);
        }
        Nonchat nonchat = (Nonchat)plugin;
        boolean globalEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.enabled", true);
        boolean pingEnabled = nonchatPlugin.getConfig().getBoolean("interactive-placeholders.ping-enabled", true);
        if (!globalEnabled || !pingEnabled) {
            return Component.text((String)text);
        }
        TextComponent.Builder builder = Component.text().content("");
        Matcher matcher = PING_PATTERN.matcher(text);
        int lastEnd = 0;
        boolean foundPing = false;
        while (matcher.find()) {
            int ping;
            if (matcher.start() > lastEnd) {
                String textBefore = text.substring(lastEnd, matcher.start());
                builder.append((Component)Component.text((String)textBefore));
            }
            NamedTextColor color = (ping = player.getPing()) < 100 ? NamedTextColor.GREEN : (ping < 300 ? NamedTextColor.GOLD : NamedTextColor.RED);
            String pingFormat = nonchatPlugin.getConfig().getString("interactive-placeholders.ping-format", "{ping}ms");
            String formattedPing = pingFormat.replace("{ping}", String.valueOf(ping));
            Component pingComponent = Component.text((String)formattedPing).color((TextColor)color);
            builder.append(pingComponent);
            lastEnd = matcher.end();
            foundPing = true;
        }
        if (lastEnd < text.length()) {
            String remainingText = text.substring(lastEnd);
            builder.append((Component)Component.text((String)remainingText));
        }
        return foundPing ? builder.build() : Component.text((String)text);
    }
}

