/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.command.impl;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class BroadcastCommand
implements CommandExecutor,
TabCompleter {
    private final PluginMessages messages;
    private final Nonchat plugin;
    private final PluginConfig config;

    public BroadcastCommand(PluginMessages messages, Nonchat plugin, PluginConfig config) {
        this.messages = messages;
        this.plugin = plugin;
        this.config = config;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        this.plugin.logCommand(command.getName(), args);
        if (!sender.hasPermission("nonchat.broadcast")) {
            this.sendNoPermissionMessage(sender);
            return true;
        }
        if (args.length == 0) {
            this.sendUsageMessage(sender);
            return true;
        }
        this.broadcastMessage(String.join((CharSequence)" ", args));
        return true;
    }

    private void sendNoPermissionMessage(CommandSender sender) {
        sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
        this.plugin.logError("Sender doesn't have broadcast permission");
    }

    private void sendUsageMessage(CommandSender sender) {
        sender.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("broadcast-command")));
        this.plugin.logError("Invalid usage: /bc <message>");
    }

    private void broadcastMessage(String message) {
        try {
            String broadcastFormat = this.config.getBroadcastFormat();
            String formattedMessage = broadcastFormat.replace("{message}", message);
            Component broadcastComponent = ColorUtil.parseComponent(formattedMessage);
            this.plugin.getServer().getOnlinePlayers().forEach(player -> player.sendMessage(broadcastComponent));
            this.plugin.getServer().getConsoleSender().sendMessage(broadcastComponent);
            this.plugin.logResponse("Broadcast sent successfully");
        }
        catch (Exception e) {
            this.plugin.logError("Failed to send broadcast: " + e.getMessage());
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nonchat.broadcast")) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.add("message");
        }
        return suggestions.stream().filter(suggestion -> suggestion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

