/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.config;

import com.nonxedy.nonchat.util.chat.filters.CapsFilter;
import com.nonxedy.nonchat.util.chat.filters.WordBlocker;
import com.nonxedy.nonchat.util.chat.formatting.ChatTypeUtil;
import com.nonxedy.nonchat.util.chat.formatting.HoverTextUtil;
import com.nonxedy.nonchat.util.core.broadcast.BroadcastMessage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class PluginConfig {
    private final File configFile = new File("plugins/nonchat", "config.yml");
    private FileConfiguration config;
    private boolean debug;
    private String language;
    private String defaultChannel;

    public PluginConfig() {
        this.loadConfig();
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.debug = this.config.getBoolean("debug", false);
        this.language = this.config.getString("language", "en");
        this.defaultChannel = this.config.getString("default-channel", "local");
    }

    private void createDefaultConfig() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            this.config = new YamlConfiguration();
            this.setDefaultValues();
            this.saveConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default config", e);
        }
    }

    private void setDefaultValues() {
        this.config.set("language", (Object)"en");
        this.config.set("debug", (Object)false);
        this.config.set("update-checker", (Object)true);
        this.config.set("default-channel", (Object)"local");
        this.config.set("message-delivery.notify-undelivered", (Object)true);
        this.config.set("interactive-placeholders.enabled", (Object)true);
        this.config.set("interactive-placeholders.item-enabled", (Object)true);
        this.config.set("interactive-placeholders.ping-enabled", (Object)true);
        this.config.set("death.enabled", (Object)true);
        this.config.set("death.format", (Object)"%luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a7f died");
        this.config.set("death.show-coordinates", (Object)true);
        this.config.set("join-messages.enabled", (Object)true);
        this.config.set("join-messages.format", (Object)"\u00a78(\u00a7a+\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
        this.config.set("quit-messages.enabled", (Object)true);
        this.config.set("quit-messages.format", (Object)"\u00a78(\u00a7c-\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
        this.config.set("private-chat-format", (Object)"\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
        this.config.set("spy-format", (Object)"\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
        this.config.set("chat-bubbles.enabled", (Object)true);
        this.config.set("chat-bubbles.duration", (Object)5);
        this.config.set("chat-bubbles.height", (Object)2.5);
        this.config.set("chat-bubbles.show-in-private-channels", (Object)false);
        this.createDefaultChannels();
        this.config.set("roleplay-commands.me.enabled", (Object)true);
        this.config.set("roleplay-commands.me.format", (Object)"&7*%player_name%: {message}");
        this.config.set("roleplay-commands.roll.enabled", (Object)true);
        this.config.set("roleplay-commands.roll.format", (Object)"&7*%player_name% rolled a {number}");
        this.config.set("hover-text.enabled", (Object)true);
        List<String> defaultHoverFormat = Arrays.asList("&#FFAFFB\u2b50 %player_name%", "&#FFAFFB\u25ba Rank: &#FFFFFF%luckperms_prefix%", "&#FFAFFB\u25ba Balance: &#FFFFFF$%vault_eco_balance%", "&#FFAFFB\u25ba Level: &#FFFFFF%player_level%", "&#FFAFFB\u25ba Playtime: &#FFFFFF%statistic_time_played%", "&#FFAFFB\u25ba Location: &#FFFFFF%player_world%", "&#FFAFFB\u25ba Ping: &#FFFFFF%player_ping%ms", "\u00a77", "\u00a78Click to send a private message");
        this.config.set("hover-text.format", defaultHoverFormat);
        this.config.set("banned-words", Arrays.asList("spam", "badword", "anotherbadword", "\u043f\u043b\u043e\u0445\u043e\u0439"));
        this.config.set("caps-filter.enabled", (Object)true);
        this.config.set("caps-filter.max-caps-percentage", (Object)70);
        this.config.set("caps-filter.min-length", (Object)4);
        this.config.set("broadcast.format", (Object)"\n\u00a7#FFAFFBBroadcast: \u00a7f{message}\n");
        this.config.set("broadcast.random", (Object)true);
        this.config.set("broadcast.example.enabled", (Object)true);
        this.config.set("broadcast.example.message", (Object)"This message will be sent every 60 seconds");
        this.config.set("broadcast.example.interval", (Object)60);
        this.config.set("anti-ad.enabled", (Object)true);
        this.config.set("anti-ad.sensitivity", (Object)0.7);
        this.config.set("anti-ad.whitelisted-urls", Arrays.asList("discord.gg/NAWsxe3J3R"));
        this.config.set("anti-ad.staff-notify", (Object)true);
        this.config.set("anti-ad.punish-command", (Object)"ban %player% advertising");
    }

    private void createDefaultChannels() {
        this.config.set("channels.global.enabled", (Object)true);
        this.config.set("channels.global.display-name", (Object)"Global");
        this.config.set("channels.global.format", (Object)"\u00a77(\u00a76G\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.global.radius", (Object)-1);
        this.config.set("channels.global.character", (Object)"!");
        this.config.set("channels.global.send-permission", (Object)"");
        this.config.set("channels.global.receive-permission", (Object)"");
        this.config.set("channels.global.cooldown", (Object)0);
        this.config.set("channels.global.min-length", (Object)0);
        this.config.set("channels.global.max-length", (Object)-1);
        this.config.set("channels.local.enabled", (Object)true);
        this.config.set("channels.local.display-name", (Object)"Local");
        this.config.set("channels.local.format", (Object)"\u00a77(\u00a76L\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.local.radius", (Object)100);
        this.config.set("channels.local.character", (Object)"");
        this.config.set("channels.local.send-permission", (Object)"");
        this.config.set("channels.local.receive-permission", (Object)"");
        this.config.set("channels.local.cooldown", (Object)0);
        this.config.set("channels.local.min-length", (Object)0);
        this.config.set("channels.local.max-length", (Object)-1);
        this.config.set("channels.staff.enabled", (Object)true);
        this.config.set("channels.staff.display-name", (Object)"Staff");
        this.config.set("channels.staff.format", (Object)"\u00a77(\u00a7bSC\u00a77)\u00a7r %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a77: \u00a7f{message}");
        this.config.set("channels.staff.radius", (Object)-1);
        this.config.set("channels.staff.character", (Object)"*");
        this.config.set("channels.staff.send-permission", (Object)"nonchat.chat.staff");
        this.config.set("channels.staff.receive-permission", (Object)"nonchat.chat.staff");
        this.config.set("channels.staff.cooldown", (Object)0);
        this.config.set("channels.staff.min-length", (Object)0);
        this.config.set("channels.staff.max-length", (Object)-1);
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @NotNull
    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public boolean isUndeliveredMessageNotificationEnabled() {
        return this.config.getBoolean("message-delivery.notify-undelivered", true);
    }

    public void setUndeliveredMessageNotificationEnabled(boolean enabled) {
        this.config.set("message-delivery.notify-undelivered", (Object)enabled);
        this.saveConfig();
    }

    public boolean isInteractivePlaceholdersEnabled() {
        return this.config.getBoolean("interactive-placeholders.enabled", true);
    }

    public boolean isItemPlaceholdersEnabled() {
        return this.config.getBoolean("interactive-placeholders.item-enabled", true);
    }

    public boolean isPingPlaceholdersEnabled() {
        return this.config.getBoolean("interactive-placeholders.ping-enabled", true);
    }

    public void setInteractivePlaceholdersEnabled(boolean enabled) {
        this.config.set("interactive-placeholders.enabled", (Object)enabled);
        this.saveConfig();
    }

    public void setItemPlaceholdersEnabled(boolean enabled) {
        this.config.set("interactive-placeholders.item-enabled", (Object)enabled);
        this.saveConfig();
    }

    public void setPingPlaceholdersEnabled(boolean enabled) {
        this.config.set("interactive-placeholders.ping-enabled", (Object)enabled);
        this.saveConfig();
    }

    public boolean isDeathMessagesEnabled() {
        return this.config.getBoolean("death.enabled", true);
    }

    public boolean isShowDeathCoordinatesEnabled() {
        return this.config.getBoolean("death.show-coordinates", true);
    }

    @NotNull
    public String getDeathFormat() {
        return this.config.getString("death.format", "%luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%\u00a7f died");
    }

    public boolean isJoinMessageEnabled() {
        return this.config.getBoolean("join-messages.enabled", true);
    }

    @NotNull
    public String getJoinFormat() {
        return this.config.getString("join-messages.format", "\u00a78(\u00a7a+\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
    }

    public boolean isQuitMessageEnabled() {
        return this.config.getBoolean("quit-messages.enabled", true);
    }

    @NotNull
    public String getQuitFormat() {
        return this.config.getString("quit-messages.format", "\u00a78(\u00a7c-\u00a78) %luckperms_prefix% \u00a7f%player_name%\u00a7r %luckperms_suffix%");
    }

    @NotNull
    public String getPrivateChatFormat() {
        return this.config.getString("private-chat-format", "\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
    }

    @NotNull
    public String getSpyFormat() {
        return this.config.getString("spy-format", "\u00a7f{sender} \u00a77-> \u00a7f{target}\u00a77: \u00a77{message}");
    }

    public boolean isBroadcastEnabled() {
        return this.config.getBoolean("broadcast.enabled", true);
    }

    @NotNull
    public String getBroadcastFormat() {
        return this.config.getString("broadcast.format", "\n\u00a7#FFAFFBBroadcast: \u00a7f{message}\n");
    }

    public void setBroadcastFormat(String format) {
        this.config.set("broadcast.format", (Object)format);
        this.saveConfig();
    }

    public boolean isRandomBroadcastEnabled() {
        return this.config.getBoolean("broadcast.random", false);
    }

    @NotNull
    public String getBroadcastMessage() {
        return this.config.getString("broadcast.message", "Default broadcast message");
    }

    public int getBroadcastInterval() {
        return this.config.getInt("broadcast.interval", 60);
    }

    @NotNull
    public Map<String, BroadcastMessage> getBroadcastMessages() {
        HashMap<String, BroadcastMessage> messages = new HashMap<String, BroadcastMessage>();
        ConfigurationSection section = this.config.getConfigurationSection("broadcast");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ConfigurationSection messageSection;
                if (key.equals("random") || (messageSection = section.getConfigurationSection(key)) == null) continue;
                messages.put(key, new BroadcastMessage(messageSection.getBoolean("enabled", true), messageSection.getString("message", "Default message"), messageSection.getInt("interval", 60)));
            }
        }
        return messages;
    }

    public boolean isChatBubblesEnabled() {
        return this.config.getBoolean("chat-bubbles.enabled", true);
    }

    public int getChatBubblesDuration() {
        return this.config.getInt("chat-bubbles.duration", 5);
    }

    public double getChatBubblesHeight() {
        return this.config.getDouble("chat-bubbles.height", 2.5);
    }

    public boolean shouldShowBubblesInPrivateChannels() {
        return this.config.getBoolean("chat-bubbles.show-in-private-channels", false);
    }

    @NotNull
    public List<String> getBannedWords() {
        return this.config.getStringList("banned-words");
    }

    @NotNull
    public WordBlocker getWordBlocker() {
        return new WordBlocker(this.getBannedWords());
    }

    public boolean isUpdateCheckerEnabled() {
        return this.config.getBoolean("update-checker", true);
    }

    public ChatTypeUtil getChatTypeByChar(char prefix) {
        Map<String, ChatTypeUtil> chats = this.getChats();
        return chats.values().stream().filter(chat -> chat.getChatChar() == prefix).findFirst().orElse(this.getDefaultChatType());
    }

    public ChatTypeUtil getDefaultChatType() {
        return this.getChats().getOrDefault("local", new ChatTypeUtil(true, "\u00a77(\u00a76L\u00a77)\u00a7r {prefix} \u00a7f{sender}\u00a7r {suffix}\u00a77: \u00a7f{message}", 100, '\u0000', null));
    }

    public boolean isChatEnabled(String channelId) {
        return this.config.getBoolean("channels." + channelId + ".enabled", false);
    }

    public void setChatEnabled(String channelId, boolean enabled) {
        this.config.set("channels." + channelId + ".enabled", (Object)enabled);
        this.saveConfig();
    }

    public Map<String, ChatTypeUtil> getChats() {
        ConfigurationSection oldSection;
        char chatChar;
        String charStr;
        int radius;
        String format;
        HashMap<String, ChatTypeUtil> channels = new HashMap<String, ChatTypeUtil>();
        ConfigurationSection section = this.config.getConfigurationSection("channels");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ConfigurationSection channelSection = section.getConfigurationSection(key);
                if (channelSection == null) continue;
                boolean enabled = channelSection.getBoolean("enabled", true);
                String displayName = channelSection.getString("display-name", key);
                format = channelSection.getString("format", "{prefix} {sender} {suffix}: {message}");
                radius = channelSection.getInt("radius", -1);
                charStr = channelSection.getString("character", "");
                chatChar = charStr.isEmpty() ? (char)'\u0000' : charStr.charAt(0);
                String sendPermission = channelSection.getString("send-permission", "");
                if (sendPermission.isEmpty() && channelSection.contains("permission")) {
                    sendPermission = channelSection.getString("permission");
                }
                String receivePermission = channelSection.getString("receive-permission", "");
                int cooldown = channelSection.getInt("cooldown", 0);
                int minLength = channelSection.getInt("min-length", 0);
                int maxLength = channelSection.getInt("max-length", -1);
                channels.put(key, new ChatTypeUtil(enabled, displayName, format, radius, chatChar, sendPermission, receivePermission, cooldown, minLength, maxLength));
            }
        }
        if ((oldSection = this.config.getConfigurationSection("chats")) != null && channels.isEmpty()) {
            for (String key : oldSection.getKeys(false)) {
                ConfigurationSection chatSection = oldSection.getConfigurationSection(key);
                if (chatSection == null) continue;
                boolean enabled = chatSection.getBoolean("enabled", true);
                format = chatSection.getString("format", "{prefix} {sender} {suffix}: {message}");
                radius = chatSection.getInt("radius", -1);
                charStr = chatSection.getString("char", "");
                chatChar = charStr.isEmpty() ? (char)'\u0000' : charStr.charAt(0);
                String permission = null;
                if (chatSection.contains("permission")) {
                    permission = chatSection.getString("permission");
                }
                channels.put(key, new ChatTypeUtil(enabled, format, radius, chatChar, permission));
            }
        }
        return channels;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getDebugLogRetentionDays() {
        return this.config.getInt("debug-log-retention-days", 7);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.config.set("debug", (Object)debug);
        this.saveConfig();
    }

    public boolean isMeCommandEnabled() {
        return this.config.getBoolean("roleplay-commands.me.enabled", true);
    }

    public String getMeFormat() {
        return this.config.getString("roleplay-commands.me.format", "&7*%player_name%: {message}");
    }

    public boolean isRollCommandEnabled() {
        return this.config.getBoolean("roleplay-commands.roll.enabled", true);
    }

    public String getRollFormat() {
        return this.config.getString("roleplay-commands.roll.format", "&7*%player_name% rolled a {number}");
    }

    public boolean isCapsFilterEnabled() {
        return this.config.getBoolean("caps-filter.enabled", true);
    }

    public int getMaxCapsPercentage() {
        return this.config.getInt("caps-filter.max-caps-percentage", 70);
    }

    public int getMinCapsLength() {
        return this.config.getInt("caps-filter.min-length", 4);
    }

    public CapsFilter getCapsFilter() {
        return new CapsFilter(this.isCapsFilterEnabled(), this.getMaxCapsPercentage(), this.getMinCapsLength());
    }

    public boolean isHoverEnabled() {
        return this.config.getBoolean("hover-text.enabled", true);
    }

    public List<String> getHoverFormat() {
        return this.config.getStringList("hover-text.format");
    }

    public HoverTextUtil getHoverTextUtil() {
        return new HoverTextUtil(this.getHoverFormat(), this.isHoverEnabled());
    }

    public boolean isAntiAdEnabled() {
        return this.config.getBoolean("anti-ad.enabled", true);
    }

    public float getAntiAdSensitivity() {
        return (float)this.config.getDouble("anti-ad.sensitivity", 0.7);
    }

    public List<String> getAntiAdWhitelistedUrls() {
        return this.config.getStringList("anti-ad.whitelisted-urls");
    }

    public boolean shouldNotifyStaffAboutAds() {
        return this.config.getBoolean("anti-ad.staff-notify", true);
    }

    public String getAntiAdPunishCommand() {
        return this.config.getString("anti-ad.punish-command", "ban %player_name% advertising");
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }
}

