/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.core;

import com.nonxedy.nonchat.Nonchat;
import com.nonxedy.nonchat.api.Channel;
import com.nonxedy.nonchat.api.ChannelAPI;
import com.nonxedy.nonchat.chat.channel.ChannelManager;
import com.nonxedy.nonchat.command.impl.IgnoreCommand;
import com.nonxedy.nonchat.config.PluginConfig;
import com.nonxedy.nonchat.config.PluginMessages;
import com.nonxedy.nonchat.util.chat.filters.AdDetector;
import com.nonxedy.nonchat.util.chat.filters.CapsFilter;
import com.nonxedy.nonchat.util.chat.filters.WordBlocker;
import com.nonxedy.nonchat.util.chat.packets.BubblePacketUtil;
import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatManager {
    private final Nonchat plugin;
    private final PluginConfig config;
    private final PluginMessages messages;
    private final ChannelManager channelManager;
    private final Pattern mentionPattern = Pattern.compile("@(\\w+)");
    private final Map<Player, List<ArmorStand>> bubbles = new ConcurrentHashMap<Player, List<ArmorStand>>();
    private final Map<Player, ReentrantLock> playerLocks = new ConcurrentHashMap<Player, ReentrantLock>();
    private IgnoreCommand ignoreCommand;
    private final AdDetector adDetector;

    public ChatManager(Nonchat plugin, PluginConfig config, PluginMessages messages) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
        this.channelManager = new ChannelManager(config);
        this.ignoreCommand = plugin.getIgnoreCommand();
        this.adDetector = new AdDetector(config, config.getAntiAdSensitivity(), config.getAntiAdPunishCommand());
        this.startBubbleUpdater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(Player player, String messageContent) {
        ReentrantLock lock = this.playerLocks.computeIfAbsent(player, p -> new ReentrantLock());
        lock.lock();
        try {
            boolean shouldShowBubble;
            String messageForLengthCheck;
            String finalMessage;
            Channel channel;
            if (this.handleBlockedWords(player, messageContent)) {
                return;
            }
            CapsFilter capsFilter = this.config.getCapsFilter();
            if (!player.hasPermission("nonchat.caps.bypass") && capsFilter.shouldFilter(messageContent)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("caps-filter").replace("{percentage}", String.valueOf(capsFilter.getMaxCapsPercentage()))));
                return;
            }
            if (this.config.isAntiAdEnabled() && !player.hasPermission("nonchat.ad.bypass") && this.adDetector.shouldFilter(player, messageContent)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("blocked-words")));
                return;
            }
            if (!player.hasPermission("nonchat.color") && ColorUtil.hasColorCodes(messageContent)) {
                messageContent = ColorUtil.stripAllColors(messageContent);
            }
            if (messageContent.length() > 0) {
                char firstChar = messageContent.charAt(0);
                channel = this.findChannelByChar(firstChar);
                if (channel != null) {
                    finalMessage = messageContent.substring(1);
                } else {
                    channel = this.channelManager.getPlayerChannel(player);
                    finalMessage = messageContent;
                }
            } else {
                channel = this.channelManager.getPlayerChannel(player);
                finalMessage = messageContent;
            }
            if (!channel.isEnabled()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("chat-disabled")));
                return;
            }
            if (!channel.canSend(player)) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("no-permission")));
                return;
            }
            String string = messageForLengthCheck = player.hasPermission("nonchat.color") ? finalMessage : ColorUtil.stripAllColors(finalMessage);
            if (messageForLengthCheck.length() < channel.getMinLength()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-too-short").replace("{min}", String.valueOf(channel.getMinLength()))));
                return;
            }
            if (channel.getMaxLength() > 0 && messageForLengthCheck.length() > channel.getMaxLength()) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-too-long").replace("{max}", String.valueOf(channel.getMaxLength()))));
                return;
            }
            if (!this.channelManager.canSendMessage(player, channel)) {
                int remainingSeconds = this.channelManager.getRemainingCooldown(player, channel);
                player.sendMessage(ColorUtil.parseComponent(this.messages.getString("channel-cooldown").replace("{seconds}", String.valueOf(remainingSeconds)).replace("{channel}", channel.getDisplayName())));
                return;
            }
            if (ChannelAPI.shouldFilterMessage(player, finalMessage, channel.getId())) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-filtered")));
                return;
            }
            String processedMessage = ChannelAPI.processMessage(player, finalMessage, channel.getId());
            if (processedMessage == null) {
                return;
            }
            String messageToSend = processedMessage;
            boolean bl = shouldShowBubble = this.config.isChatBubblesEnabled() && player.hasPermission("nonchat.chatbubbles") && this.isPublicChannel(channel);
            if (shouldShowBubble) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.removeBubble(player);
                    String bubbleMessage = player.hasPermission("nonchat.color") ? messageToSend : ColorUtil.stripAllColors(messageToSend);
                    this.createBubble(player, bubbleMessage);
                });
            }
            this.handleMentions(player, messageToSend);
            Component formattedMessage = channel.formatMessage(player, messageToSend);
            boolean messageDelivered = this.broadcastMessage(player, formattedMessage, channel, messageToSend);
            if (this.config.isUndeliveredMessageNotificationEnabled() && !messageDelivered) {
                player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("message-not-delivered")));
            }
        }
        finally {
            lock.unlock();
            if (!player.isOnline()) {
                this.playerLocks.remove(player);
            }
            this.channelManager.recordMessageSent(player);
        }
    }

    private boolean isPublicChannel(Channel channel) {
        if (this.config.shouldShowBubblesInPrivateChannels()) {
            return true;
        }
        String receivePermission = channel.getReceivePermission();
        if (receivePermission != null && !receivePermission.isEmpty()) {
            return false;
        }
        String sendPermission = channel.getSendPermission();
        return sendPermission == null || sendPermission.isEmpty();
    }

    private void startBubbleUpdater() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.bubbles.entrySet().stream().filter(entry -> ((Player)entry.getKey()).isOnline() && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
                Player player = (Player)entry.getKey();
                Location newLoc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
                BubblePacketUtil.updateBubblesLocation((List)entry.getValue(), newLoc);
            });
            this.bubbles.entrySet().removeIf(entry -> {
                if (!((Player)entry.getKey()).isOnline()) {
                    BubblePacketUtil.removeBubbles((List)entry.getValue());
                    return true;
                }
                return false;
            });
        }, 1L, 1L);
    }

    private void createBubble(Player player, String message) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Location loc = player.getLocation().add(0.0, this.config.getChatBubblesHeight(), 0.0);
        List<ArmorStand> playerBubbles = BubblePacketUtil.spawnMultilineBubble(player, message, loc);
        this.bubbles.put(player, playerBubbles);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.removeBubble(player), (long)this.config.getChatBubblesDuration() * 20L);
    }

    private void removeBubble(Player player) {
        List<ArmorStand> playerBubbles = this.bubbles.remove(player);
        if (playerBubbles != null) {
            BubblePacketUtil.removeBubbles(playerBubbles);
        }
    }

    private boolean handleBlockedWords(Player player, String message) {
        String messageToCheck;
        WordBlocker wordBlocker;
        if (!player.hasPermission("nonchat.antiblockedwords") && !(wordBlocker = this.config.getWordBlocker()).isMessageAllowed(messageToCheck = ColorUtil.stripAllColors(message))) {
            player.sendMessage(ColorUtil.parseComponentCached(this.messages.getString("blocked-words")));
            return true;
        }
        return false;
    }

    private void handleMentions(Player sender, String message) {
        String messageToCheck = ColorUtil.stripAllColors(message);
        Matcher mentionMatcher = this.mentionPattern.matcher(messageToCheck);
        ArrayList<String> mentionedNames = new ArrayList<String>();
        while (mentionMatcher.find()) {
            mentionedNames.add(mentionMatcher.group(1));
        }
        mentionedNames.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(OfflinePlayer::isOnline).forEach(player -> this.notifyMentionedPlayer((Player)player, sender));
    }

    private void notifyMentionedPlayer(Player mentioned, Player sender) {
        String mentionMessage = this.messages.getString("mentioned");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                mentionMessage = PlaceholderAPI.setPlaceholders((Player)sender, (String)mentionMessage);
            }
            catch (Exception e) {
                this.plugin.logError("Error processing mention message placeholders: " + e.getMessage());
            }
        }
        mentionMessage = mentionMessage.replace("{player}", sender.getName());
        mentioned.sendMessage(ColorUtil.parseComponent(mentionMessage));
        mentioned.playSound(mentioned.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    private boolean broadcastMessage(Player sender, Component message, Channel channel, String originalMessage) {
        Bukkit.getConsoleSender().sendMessage(message);
        long recipientCount = Bukkit.getOnlinePlayers().stream().filter(recipient -> this.ignoreCommand == null || !this.ignoreCommand.isIgnoring((Player)recipient, sender)).filter(recipient -> channel.canReceive((Player)recipient)).filter(recipient -> channel.isGlobal() || channel.isInRange(sender, (Player)recipient)).peek(recipient -> recipient.sendMessage(message)).count();
        return recipientCount > 1L;
    }

    private Channel findChannelByChar(char c) {
        return this.channelManager.findChannelByCharacter(c).orElse(null);
    }

    public boolean setPlayerChannel(Player player, String channelId) {
        return this.channelManager.setPlayerChannel(player, channelId);
    }

    public Channel getPlayerChannel(Player player) {
        return this.channelManager.getPlayerChannel(player);
    }

    public Channel getChannel(String id) {
        return this.channelManager.getChannel(id);
    }

    public Collection<Channel> getAllChannels() {
        return this.channelManager.getAllChannels();
    }

    public Collection<Channel> getEnabledChannels() {
        return this.channelManager.getEnabledChannels();
    }

    public void reloadChannels() {
        this.channelManager.loadChannels();
    }

    public Channel createChannel(String channelId, String displayName, String format, Character character, String sendPermission, String receivePermission, int radius, int cooldown, int minLength, int maxLength) {
        return this.channelManager.createChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, cooldown, minLength, maxLength);
    }

    public boolean updateChannel(String channelId, String displayName, String format, Character character, String sendPermission, String receivePermission, Integer radius, Boolean enabled, Integer cooldown, Integer minLength, Integer maxLength) {
        return this.channelManager.updateChannel(channelId, displayName, format, character, sendPermission, receivePermission, radius, enabled, cooldown, minLength, maxLength);
    }

    public boolean deleteChannel(String channelId) {
        return this.channelManager.deleteChannel(channelId);
    }

    public boolean setDefaultChannel(String channelId) {
        return this.channelManager.setDefaultChannel(channelId);
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public void setIgnoreCommand(IgnoreCommand ignoreCommand) {
        this.ignoreCommand = ignoreCommand;
    }

    public void cleanup() {
        this.bubbles.values().forEach(BubblePacketUtil::removeBubbles);
        this.bubbles.clear();
        this.playerLocks.clear();
    }
}

