/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.formatting;

public class ChatTypeUtil {
    private final boolean enabled;
    private final String displayName;
    private final String format;
    private final int radius;
    private final char chatChar;
    private final String sendPermission;
    private final String receivePermission;
    private final int cooldown;
    private final int minLength;
    private final int maxLength;

    public ChatTypeUtil(boolean enabled, String format, int radius, char chatChar, String permission) {
        this(enabled, null, format, radius, chatChar, permission, null, 0, 0, -1);
    }

    public ChatTypeUtil(boolean enabled, String displayName, String format, int radius, char chatChar, String sendPermission, String receivePermission, int cooldown, int minLength, int maxLength) {
        this.enabled = enabled;
        this.displayName = displayName != null ? displayName : "Channel";
        this.format = format;
        this.radius = radius;
        this.chatChar = chatChar;
        this.sendPermission = sendPermission;
        this.receivePermission = receivePermission;
        this.cooldown = cooldown;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFormat() {
        return this.format;
    }

    public int getRadius() {
        return this.radius;
    }

    public char getChatChar() {
        return this.chatChar;
    }

    @Deprecated
    public String getPermission() {
        return this.sendPermission;
    }

    public String getSendPermission() {
        return this.sendPermission;
    }

    public String getReceivePermission() {
        return this.receivePermission;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Deprecated
    public boolean hasPermission() {
        return this.sendPermission != null && !this.sendPermission.isEmpty();
    }

    public boolean hasSendPermission() {
        return this.sendPermission != null && !this.sendPermission.isEmpty();
    }

    public boolean hasReceivePermission() {
        return this.receivePermission != null && !this.receivePermission.isEmpty();
    }

    public boolean hasCooldown() {
        return this.cooldown > 0;
    }

    public boolean hasMinLength() {
        return this.minLength > 0;
    }

    public boolean hasMaxLength() {
        return this.maxLength >= 0;
    }

    public boolean isGlobal() {
        return this.radius == -1;
    }
}

