/*
 * Decompiled with CFR 0.152.
 */
package com.nonxedy.nonchat.util.chat.formatting;

import com.nonxedy.nonchat.util.core.colors.ColorUtil;
import com.nonxedy.nonchat.util.integration.external.IntegrationUtil;
import java.util.List;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class HoverTextUtil {
    private final List<String> hoverFormat;
    private final boolean enabled;
    private final boolean usePlaceholderAPI;

    public HoverTextUtil(List<String> format, boolean enabled) {
        this.hoverFormat = format;
        this.enabled = enabled;
        this.usePlaceholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public Component addHoverToComponent(Component component, Player player) {
        if (!this.enabled || this.hoverFormat == null || this.hoverFormat.isEmpty()) {
            return component;
        }
        String hoverText = this.buildHoverText(player);
        if (hoverText.isEmpty()) {
            return component;
        }
        Component hoverComponent = ColorUtil.parseComponent(hoverText);
        return component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.suggestCommand((String)("/m " + player.getName())));
    }

    public Component createHoverableText(String text, Player player) {
        if (!this.enabled) {
            return Component.text((String)text);
        }
        TextComponent baseComponent = Component.text((String)text);
        String hoverText = this.buildHoverText(player);
        if (hoverText.isEmpty()) {
            return baseComponent;
        }
        Component hoverComponent = ColorUtil.parseComponent(hoverText);
        return baseComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.suggestCommand((String)("/m " + player.getName())));
    }

    private String buildHoverText(Player player) {
        StringBuilder hoverBuilder = new StringBuilder();
        for (String line : this.hoverFormat) {
            String processedLine;
            if (line == null || line.trim().isEmpty() || (processedLine = this.processHoverLine(line, player)).trim().isEmpty()) continue;
            if (hoverBuilder.length() > 0) {
                hoverBuilder.append("\n");
            }
            hoverBuilder.append(processedLine);
        }
        return hoverBuilder.toString();
    }

    private String processHoverLine(String line, Player player) {
        if (line == null) {
            return "";
        }
        String prefix = IntegrationUtil.getPlayerPrefix(player);
        String balance = IntegrationUtil.getBalance(player);
        String playtime = IntegrationUtil.getPlayTime(player);
        String processed = line.replace("{player}", player.getName()).replace("{level}", String.valueOf(player.getLevel())).replace("{prefix}", prefix != null ? prefix : "").replace("{playtime}", playtime != null ? playtime : "0h").replace("{balance}", balance != null ? balance : "0");
        if (this.usePlaceholderAPI) {
            try {
                processed = PlaceholderAPI.setPlaceholders((Player)player, (String)processed);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Error processing placeholder in hover text: {0}", e.getMessage());
            }
        }
        return processed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getHoverFormat() {
        return this.hoverFormat;
    }
}

