/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.client;

import com.doggystudio.chirencqr.ltc.client.particle.LTCParticles;
import com.doggystudio.chirencqr.ltc.client.screen.FlavouringTableScreen;
import com.doggystudio.chirencqr.ltc.client.screen.LatiaoOvenScreen;
import com.doggystudio.chirencqr.ltc.client.screen.MillScreen;
import com.doggystudio.chirencqr.ltc.server.item.EvilSwordItem;
import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.item.TimeTravelerWatchItem;
import com.doggystudio.chirencqr.ltc.server.registry.LTCContainers;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipeBookTypes;
import java.awt.Color;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ltc2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)LTCContainers.LATIAO_OVEN_MENU.get()), LatiaoOvenScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)LTCContainers.MILL_MENU.get()), MillScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)LTCContainers.FLAVOURING_TABLE_MENU.get()), FlavouringTableScreen::new);
        event.enqueueWork(() -> ClientProxy.setPropertyOverride((Item)LTCItems.EVIL_SWORD.get(), new ResourceLocation("ltc2", "destroy"), (itemStack, world, livingEntity, d) -> {
            if (itemStack.m_41720_() instanceof EvilSwordItem) {
                return itemStack.m_41784_().m_128471_("destroy") ? 1.0f : 0.0f;
            }
            return 0.0f;
        }));
        event.enqueueWork(() -> ClientProxy.setPropertyOverride((Item)LTCItems.TIME_WATCH.get(), new ResourceLocation("ltc2", "time"), (itemStack, world, livingEntity, d) -> {
            if (itemStack.m_41720_() instanceof TimeTravelerWatchItem) {
                return itemStack.m_41784_().m_128471_("time") ? 1.0f : 0.0f;
            }
            return 0.0f;
        }));
        event.enqueueWork(() -> ClientProxy.setPropertyOverride(ClientProxy.legendaryLatiaoList(), new ResourceLocation("ltc2", "legendary"), (itemStack, world, livingEntity, d) -> {
            if (itemStack.m_41720_() instanceof ItemLatiaoBase) {
                return itemStack.m_41784_().m_128471_("legendary") ? 1.0f : 0.0f;
            }
            return 0.0f;
        }));
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        event.register((stack, layer) -> {
            if (stack.m_41720_() instanceof ItemLatiaoBase && layer == 0 && stack.m_41782_() && stack.m_41783_().m_128471_("legendary")) {
                return ClientProxy.getDynamicColor(3000.0);
            }
            return -1;
        }, (ItemLike[])ClientProxy.legendaryLatiaoList().toArray(Item[]::new));
        event.register((stack, layer) -> {
            if (layer == 1) {
                return ClientProxy.getBrightDynamicColor(3000.0);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)LTCItems.LEGENDARY_YUMMY_SAUCE.get(), (ItemLike)LTCItems.LATIAO_BONUS_BAG_LEGEND.get()});
    }

    public static void init() {
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(ClientProxy::registerParticles);
    }

    public static void setPropertyOverride(Item item, ResourceLocation override, ItemPropertyFunction propertyGetter) {
        ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
    }

    public static void setPropertyOverride(List<Item> items, ResourceLocation override, ItemPropertyFunction propertyGetter) {
        for (Item item : items) {
            ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipeBookTypes(RegisterRecipeBookCategoriesEvent event) {
        LTCRecipeBookTypes.register(event);
    }

    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)LTCParticles.EVIL_FLAME.get(), FlameParticle.SmallFlameProvider::new);
    }

    public static int getDynamicColor(double delay) {
        long currentTime = Util.m_137550_();
        float hue = (float)((double)currentTime % delay / delay);
        float saturation = 0.6f + 0.4f * ((float)Math.sin((double)currentTime / 500.0) * 0.5f + 0.5f);
        float brightness = 0.7f + 0.3f * ((float)Math.cos((double)currentTime / 777.0) * 0.5f + 0.5f);
        Color color = Color.getHSBColor(hue, saturation, brightness);
        return color.getRGB() & 0xFFFFFF;
    }

    public static int getBrightDynamicColor(double delay) {
        long currentTime = Util.m_137550_();
        float hue = (float)((double)currentTime % delay / delay);
        float saturation = 0.6f + 0.3f * ((float)Math.sin((double)currentTime / 500.0) * 0.5f + 0.5f);
        float brightness = 0.85f + 0.15f * ((float)Math.cos((double)currentTime / 700.0) * 0.5f + 0.5f);
        Color color = Color.getHSBColor(hue, saturation, brightness);
        return color.getRGB() & 0xFFFFFF;
    }

    private static List<Item> legendaryLatiaoList() {
        return ItemLatiaoBase.getCanLegendaryList();
    }
}

