/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.block;

import com.doggystudio.chirencqr.ltc.server.config.PepperConfig;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCBlocks;
import com.doggystudio.chirencqr.ltc.server.registry.LTCDamageTypes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEffects;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class WildPlantBlock
extends BushBlock {
    private boolean isCommonPlant;
    private boolean isNetherPlant;
    private boolean isEndPlant;
    private boolean isDesertPlant;
    private boolean isCrimsonPlant;
    private boolean isWarpedPlant;
    private static boolean flagFailedParticle = true;
    private static boolean flagSuccessParticle = true;

    public WildPlantBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_));
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        if (this.isNetherPlant) {
            return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_);
        }
        if (this.isEndPlant) {
            return state.m_60713_(Blocks.f_50259_) || state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_);
        }
        if (this.isDesertPlant) {
            return state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_49993_);
        }
        if (this.isCrimsonPlant) {
            return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50699_);
        }
        if (this.isWarpedPlant) {
            return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50690_);
        }
        if (this.isCommonPlant) {
            return state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50093_);
        }
        return this.m_6266_(state, world, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockState = levelReader.m_8055_(blockpos);
        Block pepperPlacement = blockState.m_60734_();
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_50135_ || pepperPlacement == Blocks.f_50136_) && this.isNetherPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_50259_ || pepperPlacement == Blocks.f_50080_ || pepperPlacement == Blocks.f_50723_) && this.isEndPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_49993_ || pepperPlacement == Blocks.f_49992_) && this.isDesertPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_50493_ || pepperPlacement == Blocks.f_50440_ || pepperPlacement == Blocks.f_50093_) && this.isCommonPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_50135_ || pepperPlacement == Blocks.f_50136_ || pepperPlacement == Blocks.f_50699_) && this.isCrimsonPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        if (state.m_60734_() == this && (pepperPlacement == Blocks.f_50135_ || pepperPlacement == Blocks.f_50136_ || pepperPlacement == Blocks.f_50690_) && this.isWarpedPlant) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.m_6266_(levelReader.m_8055_(blockpos), (BlockGetter)levelReader, blockpos);
    }

    public WildPlantBlock isCommonPlant() {
        this.isCommonPlant = true;
        return this;
    }

    public WildPlantBlock isNetherPlant() {
        this.isNetherPlant = true;
        return this;
    }

    public WildPlantBlock isEndPlant() {
        this.isEndPlant = true;
        return this;
    }

    public WildPlantBlock isDesertPlant() {
        this.isDesertPlant = true;
        return this;
    }

    public WildPlantBlock isCrimsonPlant() {
        this.isCrimsonPlant = true;
        return this;
    }

    public WildPlantBlock isWarpedPlant() {
        this.isWarpedPlant = true;
        return this;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        block3: {
            double d1;
            double d0;
            block2: {
                VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
                Vec3 vec3 = voxelshape.m_83215_().m_82399_();
                d0 = (double)pos.m_123341_() + vec3.f_82479_;
                d1 = (double)pos.m_123343_() + vec3.f_82481_;
                if (this != LTCBlocks.WILD_PEPPER_JOLOKIA.get()) break block2;
                for (int i = 0; i < 3; ++i) {
                    if (!random.m_188499_()) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, d0 + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.8 - random.m_188500_()), d1 + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
                }
                break block3;
            }
            if (this != LTCBlocks.WILD_PEPPER_FROST.get()) break block3;
            for (int i = 0; i < 4; ++i) {
                if (!random.m_188499_()) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, d0 + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.8 - random.m_188500_()) + 0.25, d1 + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && level.m_46791_() != Difficulty.PEACEFUL && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (this == LTCBlocks.WILD_PEPPER_JOLOKIA.get() && ((Boolean)PepperConfig.EFFECT_WILD_PEPPER_JOLOKIA.get()).booleanValue() || this == LTCBlocks.WILD_PEPPER_BLOODY.get() && ((Boolean)PepperConfig.EFFECT_WILD_PEPPER_BLOODY.get()).booleanValue()) {
                if (!livingentity.m_6673_(LTCDamageTypes.getDamageSource(level, LTCDamageTypes.HOT))) {
                    livingentity.m_7292_(new MobEffectInstance((MobEffect)LTCEffects.HOT.get(), 40));
                }
            } else if (this == LTCBlocks.WILD_PEPPER_COMPLAINED.get() && ((Boolean)PepperConfig.EFFECT_WILD_PEPPER_COMPLAINED.get()).booleanValue()) {
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 120));
            } else if (this == LTCBlocks.WILD_PEPPER_FROST.get() && ((Boolean)PepperConfig.EFFECT_WILD_PEPPER_FROST.get()).booleanValue()) {
                livingentity.m_146917_(40);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this == LTCBlocks.WILD_PEPPER_RED.get()) {
            ItemStack mainHand;
            if (level.f_46443_) {
                this.addJalapenoParticle(level, pos, level.m_213780_());
            }
            if (!level.f_46443_ && (mainHand = player.m_21120_(InteractionHand.MAIN_HAND)).m_204117_(LTCTags.CAN_IGNITE_PEPPER_RED)) {
                boolean flagNoShift;
                boolean flagShift = (Boolean)PepperConfig.HARVEST_JALAPENO_WITH_SHIFT_KEY_WILD.get() != false && this.isHoldingShift();
                boolean bl = flagNoShift = (Boolean)PepperConfig.HARVEST_JALAPENO_WITH_SHIFT_KEY_WILD.get() == false && !this.isHoldingShift();
                if (flagShift || flagNoShift) {
                    int chance;
                    if (!player.m_7500_()) {
                        mainHand.m_41774_(1);
                    }
                    if ((chance = (int)((Double)PepperConfig.JALAPENO_OBTAINED_CHANCE_WILD.get() * 100.0)) < 1) {
                        chance = 1;
                    } else if (chance > 100) {
                        chance = 100;
                    }
                    if (LTCMathHelper.drawNumber(chance)) {
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        flagSuccessParticle = false;
                        WildPlantBlock.popJalapeno(level, pos);
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        LTCTriggers.JALAPENO.trigger((ServerPlayer)player);
                    } else {
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.5f, 1.0f);
                        flagFailedParticle = false;
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void addJalapenoParticle(Level level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            int i;
            double dd2;
            double dd1;
            double dd0;
            if (!flagFailedParticle) {
                dd0 = (double)pos.m_123341_() + 0.3 + (random.m_188500_() - 0.5);
                dd1 = (double)pos.m_123342_() + 0.8 + (random.m_188500_() - 0.5) * 0.2;
                dd2 = (double)pos.m_123343_() + 0.3 + (random.m_188500_() - 0.5);
                for (i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, dd0 + 0.01 * (double)i, dd1 + (double)i * 0.1, dd2 + (double)i * 0.08, 0.0, 0.0, 0.0);
                }
                flagFailedParticle = true;
            }
            if (!flagSuccessParticle) {
                dd0 = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5);
                dd1 = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
                dd2 = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5);
                for (i = 0; i < 2; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, dd0 - 0.01 * (double)i, dd1 + (double)i * 0.1, dd2 + (double)i * 0.01, 0.0, 0.0, 0.0);
                }
                flagSuccessParticle = true;
            }
        }
    }

    public static void popJalapeno(Level level, BlockPos pos) {
        int count = (Integer)PepperConfig.COUNT_JALAPENO_OBTAINED_WILD.get();
        ItemStack stack = new ItemStack((ItemLike)LTCItems.PEPPER_JALAPENO.get(), count);
        WildPlantBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
    }

    private boolean isHoldingShift() {
        boolean l_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        boolean r_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
        return l_shift || r_shift;
    }
}

