/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.block.crops;

import com.doggystudio.chirencqr.ltc.server.api.IPepperCrop;
import com.doggystudio.chirencqr.ltc.server.block.crops.LTCPlantTypes;
import com.doggystudio.chirencqr.ltc.server.config.PepperConfig;
import com.doggystudio.chirencqr.ltc.server.registry.LTCCrops;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class CropComplainedPepper
extends CropBlock
implements IPepperCrop {
    private BlockGetter blockGetter;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CropComplainedPepper(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return ((Block)LTCCrops.PEPPER_COMPLAINED_CROP.get()).m_49966_();
    }

    protected ItemLike m_6404_() {
        return (ItemLike)LTCItems.PEPPER_COMPLAINED.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    protected boolean m_6266_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        this.blockGetter = blockGetter;
        return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50690_);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter blockGetter, BlockPos pos, Direction direction, IPlantable plantable) {
        if (direction != Direction.UP) {
            return false;
        }
        return this.canPlantPepper(state.m_60734_(), blockGetter, pos, direction, plantable);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockState = levelReader.m_8055_(blockpos);
        if (state.m_60734_() == this && (blockState.m_60734_() == Blocks.f_50135_ || blockState.m_60734_() == Blocks.f_50136_) || state.m_60713_(Blocks.f_50690_)) {
            return blockState.canSustainPlant((BlockGetter)levelReader, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.m_6266_(levelReader.m_8055_(blockpos), (BlockGetter)levelReader, blockpos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && level.m_46791_() != Difficulty.PEACEFUL && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (((Boolean)PepperConfig.EFFECT_CROP_PEPPER_COMPLAINED.get()).booleanValue()) {
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 120));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isHarvest(state)) {
            if (!world.f_46443_) {
                Block.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(1)), 2);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isHarvest(BlockState state) {
        return (Integer)state.m_61143_((Property)this.m_7959_()) >= 7;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return LTCPlantTypes.PEPPER_COMPLAINED;
    }
}

