/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.block.crops;

import com.doggystudio.chirencqr.ltc.server.api.IPepperCrop;
import com.doggystudio.chirencqr.ltc.server.config.PepperConfig;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCCrops;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropRedPepper
extends CropBlock
implements IPepperCrop {
    private static boolean flagFailedParticle = true;
    private static boolean flagSuccessParticle = true;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0)};

    public CropRedPepper(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return ((Block)LTCCrops.PEPPER_RED_CROP.get()).m_49966_();
    }

    protected ItemLike m_6404_() {
        return (ItemLike)LTCItems.PEPPER_RED.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isHarvest(state)) {
            if (!world.f_46443_) {
                ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
                if (!mainHand.m_204117_(LTCTags.CAN_IGNITE_PEPPER_RED)) {
                    Block.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(1)), 2);
                } else {
                    boolean flagNoShift;
                    boolean flagShift = (Boolean)PepperConfig.HARVEST_JALAPENO_WITH_SHIFT_KEY.get() != false && this.isHoldingShift();
                    boolean bl = flagNoShift = (Boolean)PepperConfig.HARVEST_JALAPENO_WITH_SHIFT_KEY.get() == false && !this.isHoldingShift();
                    if (flagShift || flagNoShift) {
                        int chance;
                        if (!player.m_7500_()) {
                            mainHand.m_41774_(1);
                        }
                        if ((chance = (int)((Double)PepperConfig.JALAPENO_OBTAINED_CHANCE.get() * 100.0)) < 1) {
                            chance = 1;
                        } else if (chance > 100) {
                            chance = 100;
                        }
                        if (LTCMathHelper.drawNumber(chance)) {
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            flagSuccessParticle = false;
                            CropRedPepper.popJalapeno(world, pos);
                            LTCTriggers.JALAPENO.trigger((ServerPlayer)player);
                            world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(1)), 2);
                        } else {
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.5f, 1.0f);
                            flagFailedParticle = false;
                        }
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static void popJalapeno(Level level, BlockPos pos) {
        int maxCount;
        int minCount = (Integer)PepperConfig.MIN_COUNT_JALAPENO_OBTAINED.get();
        int count = minCount < (maxCount = ((Integer)PepperConfig.MAX_COUNT_JALAPENO_OBTAINED.get()).intValue()) ? level.m_213780_().m_188503_(maxCount - minCount + 1) + minCount : 1;
        ItemStack stack = new ItemStack((ItemLike)LTCItems.PEPPER_JALAPENO.get(), count);
        CropRedPepper.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i;
        double d2;
        double d1;
        double d0;
        if (!flagFailedParticle) {
            d0 = (double)pos.m_123341_() + 0.3 + (random.m_188500_() - 0.5);
            d1 = (double)pos.m_123342_() + 0.8 + (random.m_188500_() - 0.5) * 0.2;
            d2 = (double)pos.m_123343_() + 0.3 + (random.m_188500_() - 0.5);
            for (i = 0; i < 3; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + 0.01 * (double)i, d1 + (double)i * 0.1, d2 + (double)i * 0.08, 0.0, 0.0, 0.0);
            }
            flagFailedParticle = true;
        }
        if (!flagSuccessParticle) {
            d0 = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5);
            d1 = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
            d2 = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5);
            for (i = 0; i < 2; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, d0 - 0.01 * (double)i, d1 + (double)i * 0.1, d2 + (double)i * 0.01, 0.0, 0.0, 0.0);
            }
            flagSuccessParticle = true;
        }
    }

    @Override
    public boolean isHarvest(BlockState state) {
        return (Integer)state.m_61143_((Property)this.m_7959_()) >= 7;
    }

    private boolean isHoldingShift() {
        boolean l_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        boolean r_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
        return l_shift || r_shift;
    }
}

