/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.block.entity;

import com.doggystudio.chirencqr.ltc.server.block.LatiaoOvenBlock;
import com.doggystudio.chirencqr.ltc.server.crafting.LatiaoOvenRecipe;
import com.doggystudio.chirencqr.ltc.server.crafting.menu.LatiaoOvenMenu;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCBlockEntities;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class LatiaoOvenBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_MAINSP = 1;
    public static final int SLOT_EXTRASP = 2;
    public static final int SLOT_FUEL = 3;
    public static final int SLOT_RESULT = 4;
    public static final int NUM_SLOTS = 5;
    protected static final int DATA_LIT_TIME = 0;
    protected static final int DATA_LIT_DURATION = 1;
    protected static final int DATA_COOKING_PROGRESS = 2;
    protected static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{4, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{3, 1, 2};
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> LatiaoOvenBlockEntity.this.litTime;
                case 1 -> LatiaoOvenBlockEntity.this.litDuration;
                case 2 -> LatiaoOvenBlockEntity.this.cookingProgress;
                case 3 -> LatiaoOvenBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    LatiaoOvenBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    LatiaoOvenBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    LatiaoOvenBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    LatiaoOvenBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<LatiaoOvenRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public LatiaoOvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LTCBlockEntities.LATIAO_OVEN.get(), pos, state);
        this.recipeType = (RecipeType)LTCRecipes.LATIAO_OVEN_TYPE.get();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.latiao_oven");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new LatiaoOvenMenu(id, inventory, (Container)this, this.dataAccess);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.litTime = nbt.m_128451_("BurnTime");
        this.cookingProgress = nbt.m_128451_("CookTime");
        this.cookingTotalTime = nbt.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(3));
        CompoundTag compoundtag = nbt.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("BurnTime", this.litTime);
        nbt.m_128405_("CookTime", this.cookingProgress);
        nbt.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((id, value) -> compoundtag.m_128405_(id.toString(), value.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, LatiaoOvenBlockEntity blockEntity) {
        boolean flag = blockEntity.isLit();
        boolean flag1 = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)blockEntity.items.get(3);
        if (blockEntity.isLit() || !itemstack.m_41619_() && !((ItemStack)blockEntity.items.get(0)).m_41619_()) {
            LatiaoOvenRecipe recipe = level.m_7465_().m_44015_(blockEntity.recipeType, (Container)blockEntity, level).orElse(null);
            int i = blockEntity.m_6893_();
            if (!blockEntity.isLit() && blockEntity.canBurn(level.m_9598_(), recipe, blockEntity.items, i)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(itemstack);
                if (blockEntity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        blockEntity.items.set(3, (Object)itemstack.getCraftingRemainingItem());
                    } else if (!itemstack.m_41619_()) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            blockEntity.items.set(3, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.canBurn(level.m_9598_(), recipe, blockEntity.items, i)) {
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = LatiaoOvenBlockEntity.getTotalCookTime(level, blockEntity.recipeType, (Container)blockEntity);
                    if (blockEntity.burn(level.m_9598_(), recipe, blockEntity.items, i)) {
                        blockEntity.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.m_14045_((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (flag != blockEntity.isLit()) {
            flag1 = true;
            blockState = (BlockState)blockState.m_61124_((Property)LatiaoOvenBlock.f_48684_, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, blockState, 3);
        }
        if (flag1) {
            LatiaoOvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)blockState);
        }
    }

    private boolean canBurn(RegistryAccess registryAccess, @Nullable LatiaoOvenRecipe recipe, NonNullList<ItemStack> container, int maxCount) {
        if (!((ItemStack)container.get(0)).m_41619_() && recipe != null) {
            ItemStack itemstack = recipe.m_5874_((Container)this, registryAccess);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack resultSlot = (ItemStack)container.get(4);
            if (resultSlot.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)resultSlot, (ItemStack)itemstack)) {
                return false;
            }
            if (resultSlot.m_41613_() + itemstack.m_41613_() <= maxCount && resultSlot.m_41613_() + itemstack.m_41613_() <= resultSlot.m_41741_()) {
                return true;
            }
            return resultSlot.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(RegistryAccess registryAccess, @Nullable LatiaoOvenRecipe recipe, NonNullList<ItemStack> container, int maxCount) {
        if (recipe != null && this.canBurn(registryAccess, recipe, container, maxCount)) {
            ItemStack input = (ItemStack)container.get(0);
            ItemStack mainsp = (ItemStack)container.get(1);
            ItemStack extrasp = (ItemStack)container.get(2);
            ItemStack itemstack1 = recipe.m_5874_((Container)this, registryAccess);
            ItemStack resultSlot = (ItemStack)container.get(4);
            int mainspCount = recipe.getMainSpiceCount();
            int extraspCount = recipe.getExtraSpiceCount();
            if (resultSlot.m_41619_()) {
                container.set(4, (Object)itemstack1.m_41777_());
            } else if (resultSlot.m_150930_(itemstack1.m_41720_())) {
                resultSlot.m_41769_(itemstack1.m_41613_());
            }
            input.m_41774_(1);
            if (!mainsp.m_41619_()) {
                mainsp.m_41774_(mainspCount);
            }
            if (!extrasp.m_41619_()) {
                extrasp.m_41774_(extraspCount);
            }
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)itemStack, this.recipeType) / 2;
    }

    private static int getTotalCookTime(Level level, RecipeType<LatiaoOvenRecipe> recipeType, Container container) {
        return level.m_7465_().m_44015_(recipeType, container, level).map(LatiaoOvenRecipe::getCookingTime).orElse(200);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack itemStack, Direction direction) {
        if (direction == Direction.DOWN && index == 3) {
            return itemStack.m_150930_(Items.f_42447_) || itemStack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack itemStack) {
        ItemStack slot = (ItemStack)this.items.get(index);
        boolean flag = !itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)slot);
        this.items.set(index, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        if (!(index != 0 && index != 1 && index != 2 || flag)) {
            this.cookingTotalTime = LatiaoOvenBlockEntity.getTotalCookTime(this.f_58857_, this.recipeType, (Container)this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack itemStack) {
        if (index == 4) {
            return false;
        }
        if (index != 3) {
            return true;
        }
        ItemStack fuelItemStack = (ItemStack)this.items.get(3);
        return ForgeHooks.getBurnTime((ItemStack)itemStack, this.recipeType) > 0 || itemStack.m_150930_(Items.f_42446_) && !fuelItemStack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.f_58857_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                LatiaoOvenBlockEntity.createExp(level, pos, ((LatiaoOvenRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void createExp(ServerLevel level, Vec3 position, float value) {
        RandomSource random = level.m_213780_();
        float f1 = LTCMathHelper.dpf_s(value);
        int f2 = (int)value;
        f2 = f1 + random.m_188501_() <= 0.8f ? ++f2 : (f2 += 2);
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)f2);
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack itemstack : this.items) {
            contents.m_36491_(itemstack);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

