/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.compat.jei;

import com.doggystudio.chirencqr.ltc.server.compat.jei.JEIPlugins;
import com.doggystudio.chirencqr.ltc.server.crafting.ExtraSpiceCustomRecipe;
import com.doggystudio.chirencqr.ltc.server.misc.EnumLatiaoGrade;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCBlocks;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ExtraSpiceRecipeCategory
implements IRecipeCategory<ExtraSpiceCustomRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ltc2", "textures/gui/extra_spice_jei.png");
    private static final int EFFECTS_PER_PAGE = 5;
    private List<HashMap<MobEffectInstance, String>> currentPageEffects;
    private HashMap<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance, Integer> pageEffect = new HashMap();
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public ExtraSpiceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 154, 67);
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)LTCBlocks.FLAVOURING_TABLE.get()));
    }

    public RecipeType<ExtraSpiceCustomRecipe> getRecipeType() {
        return JEIPlugins.EXTRA_SPICE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.ltc2.extra_spice");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ExtraSpiceCustomRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics transform, double mouseX, double mouseY) {
        int xPos = 24;
        int yPos = 37;
        int iconSize = 18;
        int spacing = 4;
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        long currentTime = minecraft.f_91073_.m_46467_();
        boolean hasEffects = false;
        int effectsDrawn = 0;
        for (ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance exEffect : recipe.getCustomEffects()) {
            int currentPage = recipe.getJEIPage();
            MobEffectInstance effectInstance = exEffect.getEffectInstance();
            if (currentPage != this.pageEffect.get(exEffect)) continue;
            MobEffect effect = effectInstance.m_19544_();
            hasEffects = true;
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (effectId == null) continue;
            String effectName = effectId.m_135815_();
            ResourceLocation iconLocation = new ResourceLocation(effectId.m_135827_(), "textures/mob_effect/" + effectName + ".png");
            transform.m_280163_(iconLocation, xPos, yPos, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            if (mouseX >= (double)xPos && mouseX <= (double)(xPos + iconSize) && mouseY >= (double)yPos && mouseY <= (double)(yPos + iconSize)) {
                int grade;
                String gradeText;
                String probabilityText = exEffect.getProbability() * 100.0f + "%";
                int probTextLength = probabilityText.length();
                transform.m_280056_(fontRenderer, probabilityText, xPos - 2 - probTextLength / 2, yPos + 23, 6250352, false);
                MutableComponent effectTooltip = Component.m_237115_((String)effect.m_19481_());
                if (effectInstance.m_19564_() > 0) {
                    effectTooltip = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectTooltip, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))});
                }
                String string = gradeText = (grade = (int)(currentTime / 40L % 7L) + 1) != 7 ? String.valueOf(grade) : "legendary_feast";
                effectTooltip = exEffect.getDurationRule().equals("ALWAYS") ? Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectTooltip, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)}).m_130940_(ChatFormatting.BLUE) : (exEffect.getDurationRule().equals("ADDITION") ? Component.m_237115_((String)("tooltip.ltc2.latiao_grade_" + gradeText)).m_130938_(EnumLatiaoGrade.getStyleByLatiaoGrade(grade)).m_130946_(": ").m_7220_((Component)Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectTooltip, StringUtil.m_14404_((int)(effectInstance.m_19557_() * grade))}).m_130940_(ChatFormatting.BLUE)) : (exEffect.getDurationRule().equals("POW2_MINUS1") ? Component.m_237115_((String)("tooltip.ltc2.latiao_grade_" + gradeText)).m_130938_(EnumLatiaoGrade.getStyleByLatiaoGrade(grade)).m_130946_(": ").m_7220_((Component)Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectTooltip, StringUtil.m_14404_((int)((int)((double)effectInstance.m_19557_() * Math.pow(2.0, grade - 1))))}).m_130940_(ChatFormatting.BLUE)) : Component.m_237115_((String)("tooltip.ltc2.latiao_grade_" + gradeText)).m_130938_(EnumLatiaoGrade.getStyleByLatiaoGrade(grade)).m_130946_(": ").m_7220_((Component)Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectTooltip, StringUtil.m_14404_((int)LTCMathHelper.calculateDurationBasedOnLatiaoGrade(effectInstance.m_19557_(), grade != 7 ? grade : 6))}).m_130940_(ChatFormatting.BLUE))));
                transform.m_280666_(minecraft.f_91062_, List.of(effectTooltip), (int)mouseX - 7, (int)mouseY - 3);
            }
            xPos += iconSize + spacing;
            if (++effectsDrawn < 5) continue;
            break;
        }
        if (!hasEffects) {
            MutableComponent noEffectsString = Component.m_237115_((String)"gui.ltc2.extra_spice.no_effects");
            int stringWidth = fontRenderer.m_92852_((FormattedText)noEffectsString);
            transform.m_280614_(fontRenderer, (Component)noEffectsString, this.background.getWidth() / 2 - stringWidth / 2, 42, 0xFFFFFF, true);
        }
        if (!recipe.getEvents().isEmpty()) {
            MutableComponent eventString = Component.m_237115_((String)"gui.ltc2.extra_spice.events");
            for (int i = 0; i < recipe.getEvents().size(); ++i) {
                String event = recipe.getEvents().get(i);
                eventString = eventString.m_7220_((Component)Component.m_237115_((String)event));
                if (i >= recipe.getEvents().size() - 1) continue;
                eventString = eventString.m_7220_((Component)Component.m_237115_((String)"gui.ltc2.extra_spice.comma"));
            }
            int stringWidth = fontRenderer.m_92852_((FormattedText)eventString);
            transform.m_280614_(fontRenderer, (Component)eventString, this.background.getWidth() / 2 - stringWidth / 2 + 1, 24, 267539024, false);
            transform.m_280614_(fontRenderer, (Component)eventString, this.background.getWidth() / 2 - stringWidth / 2, 23, 10372682, false);
        }
        this.drawPageButtons(transform, mouseX, mouseY, recipe);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ExtraSpiceCustomRecipe recipe, IFocusGroup focuses) {
        this.initializePageEffects(recipe);
        builder.addSlot(RecipeIngredientRole.INPUT, 69, 1).addItemStack(recipe.getItem());
    }

    public boolean isHandled(ExtraSpiceCustomRecipe recipe) {
        return !recipe.m_5598_();
    }

    private void drawPageButtons(GuiGraphics transform, double mouseX, double mouseY, ExtraSpiceCustomRecipe recipe) {
        int buttonWidth = 12;
        int buttonHeight = 17;
        int buttonY = 38;
        int leftButtonX = 4;
        int rightButtonX = 138;
        if (recipe.getJEIPage() != 0) {
            this.drawButton(transform, mouseX, mouseY, 4, 38, 167, 0, 12, 17);
        }
        if (recipe.getJEIPage() != recipe.getJEIMaxPage()) {
            this.drawButton(transform, mouseX, mouseY, 138, 38, 154, 0, 12, 17);
        }
    }

    private void drawButton(GuiGraphics transform, double mouseX, double mouseY, int x, int y, int textureX, int textureY, int width, int height) {
        transform.m_280218_(TEXTURE, x, y, textureX, textureY, width, height);
        if (mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height)) {
            transform.m_280218_(TEXTURE, x, y, textureX, textureY + 18, width, height);
        }
    }

    public boolean handleInput(@NotNull ExtraSpiceCustomRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        int buttonWidth = 12;
        int buttonHeight = 17;
        int buttonY = 38;
        int leftButtonX = 4;
        int rightButtonX = 138;
        int maxPage = recipe.getJEIMaxPage();
        if (this.isButtonClicked(mouseX, mouseY, 4, 38, 12, 17) && recipe.getJEIPage() > 0) {
            recipe.setJEIPage(recipe.getJEIPage() - 1);
            return true;
        }
        if (this.isButtonClicked(mouseX, mouseY, 138, 38, 12, 17) && recipe.getJEIPage() < maxPage) {
            recipe.setJEIPage(recipe.getJEIPage() + 1);
            return true;
        }
        return false;
    }

    private boolean isButtonClicked(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    private void initializePageEffects(ExtraSpiceCustomRecipe recipe) {
        recipe.setJEIPage(0);
        int pageIndex = 0;
        for (int i = 0; i < recipe.getCustomEffects().size(); ++i) {
            if (i > 0 && i % 5 == 0) {
                ++pageIndex;
            }
            this.pageEffect.put(recipe.getCustomEffects().get(i), pageIndex);
        }
    }
}

