/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.compat.jei;

import com.doggystudio.chirencqr.ltc.server.compat.jei.JEIPlugins;
import com.doggystudio.chirencqr.ltc.server.crafting.PepperTransmutationRecipe;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class PepperTransmutationRecipeCategory
implements IRecipeCategory<PepperTransmutationRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ltc2", "textures/gui/pepper_transmutation_jei.png");
    public static final ResourceLocation ICON = new ResourceLocation("ltc2", "textures/gui/jei_icons.png");
    private final IDrawable background;
    private final IDrawable icon;

    public PepperTransmutationRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 128, 70);
        this.icon = guiHelper.createDrawable(ICON, 0, 0, 16, 16);
    }

    public RecipeType<PepperTransmutationRecipe> getRecipeType() {
        return JEIPlugins.PEPPER_TRANSMUTATION;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.ltc2.pepper_transmutation");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(PepperTransmutationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics transform, double mouseX, double mouseY) {
        this.drawExperience(recipe, transform);
        this.drawChance(recipe, transform);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PepperTransmutationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 34).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 57, 5).addIngredients(PepperTransmutationRecipeCategory.convertTag(LTCTags.WILD_PEPPERS));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 34).addItemStack(recipe.getOutput());
    }

    protected void drawExperience(PepperTransmutationRecipe recipe, GuiGraphics transform) {
        float experience = recipe.getExp();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.ltc2.pepper_transmutation.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            transform.m_280614_(fontRenderer, (Component)experienceString, this.background.getWidth() - stringWidth, this.background.getHeight() - 10, -8355712, false);
        }
    }

    protected void drawChance(PepperTransmutationRecipe recipe, GuiGraphics transform) {
        int chance = recipe.getChance();
        MutableComponent chanceString = Component.m_237110_((String)"gui.ltc2.pepper_transmutation.chance", (Object[])new Object[]{chance}).m_130946_("%");
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)chanceString);
        transform.m_280614_(fontRenderer, (Component)chanceString, 1, this.background.getHeight() - 10, -8355712, false);
    }

    private static Ingredient convertTag(TagKey<Block> blockTag) {
        List blocks = ForgeRegistries.BLOCKS.tags().getTag(blockTag).stream().collect(Collectors.toList());
        List<Item> items = blocks.stream().map(block -> block.m_5456_()).filter(item -> item instanceof BlockItem).collect(Collectors.toList());
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])items.toArray(new Item[0])));
    }
}

