/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue WANDERING_TRADER;
    public static ForgeConfigSpec.BooleanValue EVIL_SWOLD_SKILL;
    public static ForgeConfigSpec.BooleanValue WARDEN_DROP;
    public static ForgeConfigSpec.BooleanValue STRIDER_DROP;
    public static ForgeConfigSpec.BooleanValue RAVAGER_DROP;
    public static ForgeConfigSpec.BooleanValue UNDEAD_DROP;
    public static ForgeConfigSpec.BooleanValue LATIAO_MENDING_ARMOR;
    public static ForgeConfigSpec.IntValue MIN_COUNT_UNDYING_DUST;
    public static ForgeConfigSpec.IntValue MAX_COUNT_UNDYING_DUST;
    public static ForgeConfigSpec.IntValue MAX_COUNT_ENCHANTER_BOOK;
    public static ForgeConfigSpec.BooleanValue ENCHANTER_BOOK_LEVEL;
    public static ForgeConfigSpec.IntValue MAX_COUNT_LATIAO_FRAME;
    public static ForgeConfigSpec.IntValue MAX_COUNT_LEGENDARY_SAUCE;
    public static ForgeConfigSpec.DoubleValue FERTILIZER_PEPPER_GEN_CHANCE;
    public static ForgeConfigSpec.IntValue MIN_COUNT_FERTILIZER_PEPPER_GEN;
    public static ForgeConfigSpec.IntValue MAX_COUNT_FERTILIZER_PEPPER_GEN;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("Common / \u4e00\u822c\u8bbe\u7f6e");
        builder.comment("Allow the Wandering Traders to sell items from Latiao Craft 2 / \u6d41\u6d6a\u5546\u4eba\u662f\u5426\u4f1a\u8d29\u5356\u672c\u6a21\u7ec4\u7684\u7269\u54c1");
        WANDERING_TRADER = builder.define("WanderingTraderSell", true);
        builder.comment("The Evil Sword can use skill / \u8870\u6076\u4e4b\u5251\u662f\u5426\u53ef\u4ee5\u4f7f\u7528\u6280\u80fd");
        EVIL_SWOLD_SKILL = builder.define("EvilSwordSkill", true);
        builder.comment("Minimum Undying Dust count obtained after consuming Undying Latiao / \u901a\u8fc7\u98df\u7528\u4e0d\u6b7b\u8fa3\u6761\u83b7\u53d6\u4e0d\u6b7b\u7c89\u5c18\u7684\u6700\u5c0f\u6570\u91cf");
        MIN_COUNT_UNDYING_DUST = builder.defineInRange("MinUndyingDustCount", 5, 0, 127);
        builder.comment("Maximum Undying Dust count obtained after consuming Undying Latiao / \u901a\u8fc7\u98df\u7528\u4e0d\u6b7b\u8fa3\u6761\u83b7\u53d6\u4e0d\u6b7b\u7c89\u5c18\u7684\u6700\u5927\u6570\u91cf");
        MAX_COUNT_UNDYING_DUST = builder.defineInRange("MaxUndyingDustCount", 10, 1, 128);
        builder.comment("The count of enchanted books obtained after consuming Enchanter Latiao / \u901a\u8fc7\u98df\u7528\u9644\u9b54\u5e08\u8fa3\u6761\u53ef\u83b7\u53d6\u9644\u9b54\u4e66\u7684\u6570\u91cf");
        MAX_COUNT_ENCHANTER_BOOK = builder.defineInRange("EnchanterBookCount", 10, 1, 128);
        builder.comment("Are the enchanted books obtained from consuming Enchanter Latiao always at its maximum level / \u901a\u8fc7\u98df\u7528\u9644\u9b54\u5e08\u8fa3\u6761\u83b7\u53d6\u7684\u9644\u9b54\u4e66\u662f\u5426\u4e3a\u6700\u5927\u7b49\u7ea7");
        builder.comment("true: fixed maximum level | false: random level / true\uff1a\u56fa\u5b9a\u6700\u5927\u7b49\u7ea7 | false\uff1a\u968f\u673a\u7b49\u7ea7");
        ENCHANTER_BOOK_LEVEL = builder.define("EnchanterBookLevel", true);
        builder.comment("The count of Latiao Frames obtained after consuming Duplishape Latiao / \u901a\u8fc7\u98df\u7528\u884d\u53d8\u8fa3\u6761\u53ef\u83b7\u53d6\u8fa3\u6761\u6846\u67b6\u7684\u6570\u91cf");
        MAX_COUNT_LATIAO_FRAME = builder.defineInRange("LatiaoFrameCount", 16, 1, 128);
        builder.comment("The count of Legendary Yummy Sauce obtained after consuming Duplishape Latiao / \u901a\u8fc7\u98df\u7528\u884d\u53d8\u8fa3\u6761\u53ef\u83b7\u53d6\u4f20\u4e16\u7f8e\u5473\u9171\u7684\u6570\u91cf");
        MAX_COUNT_LEGENDARY_SAUCE = builder.defineInRange("LegendaryYummySauceCount", 16, 1, 128);
        builder.comment("Does Latiao Mending work on items in armor slots? / \u201c\u8fa3\u6761\u4fee\u8865\u201d\u662f\u5426\u5bf9\u62a4\u7532\u69fd\u7684\u7269\u54c1\u751f\u6548");
        LATIAO_MENDING_ARMOR = builder.define("LatiaoMendingArmor", false);
        builder.pop();
        builder.push("Mob Drop / \u751f\u7269\u6389\u843d");
        builder.comment("Allow the Warden to drop items from Latiao Craft 2 / \u76d1\u5b88\u8005\u662f\u5426\u4f1a\u6389\u843d\u672c\u6a21\u7ec4\u7684\u7269\u54c1");
        WARDEN_DROP = builder.define("WardenDrop", true);
        builder.comment("Allow the Strider to drop items from Latiao Craft 2 / \u70bd\u8db3\u517d\u662f\u5426\u4f1a\u6389\u843d\u672c\u6a21\u7ec4\u7684\u7269\u54c1");
        STRIDER_DROP = builder.define("StriderDrop", true);
        builder.comment("Allow the Ravager to drop items from Latiao Craft 2 / \u52ab\u63a0\u517d\u662f\u5426\u4f1a\u6389\u843d\u672c\u6a21\u7ec4\u7684\u7269\u54c1");
        RAVAGER_DROP = builder.define("RavagerDrop", true);
        builder.comment("Allow the Undead mob to drop items from Latiao Craft 2 / \u4ea1\u7075\u751f\u7269\u662f\u5426\u4f1a\u6389\u843d\u672c\u6a21\u7ec4\u7684\u7269\u54c1");
        UNDEAD_DROP = builder.define("UndeadDrop", true);
        builder.pop();
        builder.push("Pepper Fertilizer / \u8fa3\u6912\u50ac\u751f\u7c89");
        builder.comment("Minimum wild pepper count when using Pepper Fertilizer / \u4f7f\u7528\u8fa3\u6912\u50ac\u751f\u7c89\u751f\u6210\u7684\u91ce\u751f\u8fa3\u6912\u6700\u5c0f\u6570\u91cf");
        MIN_COUNT_FERTILIZER_PEPPER_GEN = builder.defineInRange("MinWildPepperCountFertilizer", 5, 0, 24);
        builder.comment("Maximum wild pepper count when using Pepper Fertilizer / \u4f7f\u7528\u8fa3\u6912\u50ac\u751f\u7c89\u751f\u6210\u7684\u91ce\u751f\u8fa3\u6912\u6700\u5927\u6570\u91cf");
        MAX_COUNT_FERTILIZER_PEPPER_GEN = builder.defineInRange("MaxWildPepperCountFertilizer", 8, 1, 25);
        builder.comment("Wild Pepper Generation Bias with Pepper Fertilizer / \u91ce\u751f\u8fa3\u6912\u751f\u6210\u6982\u7387\u56e0\u5b50");
        builder.comment("The higher this value is, the closer the number of peppers generated with fertilizer will be to the maximum / \u6b64\u503c\u8d8a\u5927\uff0c\u5219\u4f7f\u7528\u8fa3\u6912\u50ac\u751f\u7c89\u751f\u6210\u7684\u91ce\u751f\u8fa3\u6912\u6570\u91cf\u8d8a\u63a5\u8fd1\u6700\u5927\u503c\u3002");
        FERTILIZER_PEPPER_GEN_CHANCE = builder.defineInRange("WildPepperGenChanceFetilizer", 0.25, 0.01, 0.99);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        CommonConfig.init(builder);
        SPEC = builder.build();
    }
}

