/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting;

import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class DamageableToolShapelessRecipe
extends ShapelessRecipe {
    private final ResourceLocation id;
    private final Ingredient toolIngredient;

    public DamageableToolShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, Ingredient toolIngredient) {
        super(id, group, category, result, ingredients);
        this.id = id;
        this.toolIngredient = toolIngredient;
    }

    public Ingredient getToolIngredient() {
        return this.toolIngredient;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        if (!super.m_5818_(inv, level)) {
            return false;
        }
        boolean foundTool = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !this.toolIngredient.test(stack)) continue;
            foundTool = true;
            break;
        }
        return foundTool;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_41619_() && this.toolIngredient.test(stack)) {
                ItemStack copy = stack.m_41777_();
                copy.m_41721_(copy.m_41773_() + 1);
                if (copy.m_41619_()) continue;
                remaining.set(i, (Object)copy);
                continue;
            }
            if (stack.m_41619_() || !stack.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return remaining;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LTCRecipes.DAMAGEABLE_TOOL_SHAPELESS_SERIALIZER.get();
    }
}

