/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting;

import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.misc.SecondaryFlavour;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCSecondaryFlavours;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ExtraSpiceCustomRecipe
implements Recipe<Container> {
    private ResourceLocation id;
    private ItemStack item;
    private List<String> events;
    private List<ExtraSpiceEffectInstance> customEffects;
    private int page = 0;

    public ExtraSpiceCustomRecipe(ResourceLocation id, ItemStack item, List<ExtraSpiceEffectInstance> customEffects, List<String> events) {
        this.id = id;
        this.item = item;
        this.customEffects = customEffects;
        this.events = events;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public List<ExtraSpiceEffectInstance> getCustomEffects() {
        return this.customEffects;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public boolean m_5818_(Container container, Level level) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.item;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.item;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LTCRecipes.EXTRA_SPICE_CUSTOM_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)LTCRecipes.EXTRA_SPICE_CUSTOM_TYPE.get();
    }

    public int getJEIPage() {
        return this.page;
    }

    public void setJEIPage(int page) {
        this.page = page;
    }

    public int getJEIMaxPage() {
        int maxPage = 0;
        for (int i = 0; i < this.getCustomEffects().size(); ++i) {
            if (i <= 0 || i % 5 != 0) continue;
            ++maxPage;
        }
        return maxPage;
    }

    public static class ExtraSpiceEffectInstance {
        private MobEffectInstance effectInstance;
        private float probability;
        private String durationRule;

        public ExtraSpiceEffectInstance(MobEffectInstance effectInstance, Float probability, String durationRule) {
            this.effectInstance = effectInstance;
            this.probability = probability.floatValue();
            this.durationRule = durationRule;
        }

        public MobEffectInstance getEffectInstance() {
            return this.effectInstance;
        }

        public float getProbability() {
            return this.probability;
        }

        public String getDurationRule() {
            return this.durationRule;
        }
    }

    @Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ExtraSpiceCustomRegistry {
        @SubscribeEvent
        public void processCustomExtraSpice(LivingEntityUseItemEvent.Finish event) {
            ItemStack stack = event.getItem();
            Item item = stack.m_41720_();
            if (item instanceof ItemLatiaoBase) {
                ItemLatiaoBase latiao = (ItemLatiaoBase)item;
                int grd = latiao.getLatiaoGradeValue(stack);
                List recipes = event.getEntity().m_9236_().m_7465_().m_44013_((RecipeType)LTCRecipes.EXTRA_SPICE_CUSTOM_TYPE.get());
                for (ExtraSpiceCustomRecipe recipe : recipes) {
                    CompoundTag tag;
                    int latiaoGrade;
                    if (!stack.m_41782_()) continue;
                    int n = latiaoGrade = SecondaryFlavour.isAlive(stack, LTCSecondaryFlavours.LIME) ? grd + 1 : grd;
                    if (stack.m_41783_().m_128441_("ltc2.ex_spice")) {
                        tag = stack.m_41783_();
                        String spice = tag.m_128461_("ltc2.ex_spice");
                        this.runExtraSpice(spice, recipe, latiaoGrade, event);
                    }
                    if (!stack.m_41783_().m_128441_("ltc2.ex_spice2")) continue;
                    tag = stack.m_41783_();
                    String spice2 = tag.m_128461_("ltc2.ex_spice2");
                    this.runExtraSpice(spice2, recipe, latiaoGrade, event);
                }
            }
        }

        private void runExtraSpice(String spice, ExtraSpiceCustomRecipe extraSpiceRecipe, int latiaoGrade, LivingEntityUseItemEvent.Finish event) {
            if (spice.equals(extraSpiceRecipe.getItem().m_41778_())) {
                for (ExtraSpiceEffectInstance exEffect : extraSpiceRecipe.getCustomEffects()) {
                    int finalDuration;
                    String durationBased;
                    MobEffectInstance effectInstance = exEffect.getEffectInstance();
                    switch (durationBased = exEffect.durationRule) {
                        case "ALWAYS": {
                            int n = effectInstance.m_19557_();
                            break;
                        }
                        case "ADDITION": {
                            int n = effectInstance.m_19557_() * latiaoGrade;
                            break;
                        }
                        case "POW2_MINUS1": {
                            int n = (int)((double)effectInstance.m_19557_() * Math.pow(2.0, latiaoGrade - 1));
                            break;
                        }
                        default: {
                            int n = finalDuration = LTCMathHelper.calculateDurationBasedOnLatiaoGrade(effectInstance.m_19557_(), latiaoGrade);
                        }
                    }
                    if (!LTCMathHelper.drawNumber((int)(exEffect.probability * 100.0f))) continue;
                    event.getEntity().m_7292_(new MobEffectInstance(effectInstance.m_19544_(), finalDuration, effectInstance.m_19564_()));
                }
            }
        }
    }
}

