/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting;

import com.doggystudio.chirencqr.ltc.server.api.ILegendaryFeastLatiao;
import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.item.UpgradableLatiaoItem;
import com.doggystudio.chirencqr.ltc.server.misc.LTCStringHelper;
import com.doggystudio.chirencqr.ltc.server.misc.SecondaryFlavour;
import com.doggystudio.chirencqr.ltc.server.misc.SecondaryFlavourRegistry;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCSecondaryFlavours;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class FlavouringRecipe
extends CustomRecipe {
    private static final Ingredient LATIAO = Ingredient.m_204132_(LTCTags.F_LATIAO);
    private static final Ingredient SALT = Ingredient.m_204132_(LTCTags.F_SALT);
    private static final Ingredient SUGAR = Ingredient.m_204132_(LTCTags.F_SUGAR);
    private static final Ingredient SPICE = Ingredient.m_204132_(LTCTags.EXTRA_SPICE);
    private static final Ingredient FLOUR = Ingredient.m_204132_(LTCTags.FLOUR);
    private static final Ingredient ALL_LATIAO = Ingredient.m_204132_(LTCTags.ALL_LATIAO);
    private static final Ingredient CLONE_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)LTCItems.LATIAO_FRAME.get()});
    private static final Ingredient UPGRADE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)LTCItems.YUMMY_SAUCE.get(), (ItemLike)LTCItems.LEGENDARY_YUMMY_SAUCE.get()});
    private static List<Item> spices = new ArrayList<Item>();
    private static final List<SecondaryFlavour> secondaryFlavours = SecondaryFlavourRegistry.getREGISTRIES();

    public FlavouringRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean flag1;
        boolean hasLatiao = false;
        boolean hasCloneItem = false;
        boolean hasFlavorLatiao = false;
        boolean hasLatiaoSweet = false;
        boolean hasLatiaoSalted = false;
        boolean hasLatiaoF2 = false;
        boolean hasLatiaoSpice = false;
        boolean hasLatiaoSpice2 = false;
        boolean hasSugar = false;
        boolean hasSalt = false;
        boolean hasF2 = false;
        boolean hasSpice = false;
        boolean hasUpgrade = false;
        boolean hasFlour = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            boolean matchF2 = false;
            for (SecondaryFlavour f2 : secondaryFlavours) {
                if (!f2.getIngredient().test(itemstack)) continue;
                matchF2 = true;
                break;
            }
            if (itemstack.m_41619_()) continue;
            if (ALL_LATIAO.test(itemstack)) {
                hasLatiao = true;
                if (!LATIAO.test(itemstack)) continue;
                if (hasFlavorLatiao) {
                    return false;
                }
                hasFlavorLatiao = true;
                if (!itemstack.m_41782_()) continue;
                CompoundTag tag = itemstack.m_41783_();
                hasLatiaoSweet = tag.m_128441_("ltc2.sweet");
                hasLatiaoSalted = tag.m_128441_("ltc2.salted");
                hasLatiaoF2 = tag.m_128441_("ltc2.secondary_flavour");
                hasLatiaoSpice = tag.m_128441_("ltc2.ex_spice");
                hasLatiaoSpice2 = tag.m_128441_("ltc2.ex_spice2");
                continue;
            }
            if (CLONE_ITEM.test(itemstack)) {
                if (hasCloneItem) {
                    return false;
                }
                hasCloneItem = true;
                continue;
            }
            if (SUGAR.test(itemstack)) {
                if (hasSugar) {
                    return false;
                }
                hasSugar = true;
                continue;
            }
            if (SALT.test(itemstack)) {
                if (hasSalt) {
                    return false;
                }
                hasSalt = true;
                continue;
            }
            if (matchF2) {
                if (hasF2) {
                    return false;
                }
                hasF2 = true;
                continue;
            }
            if (SPICE.test(itemstack)) {
                if (hasSpice) {
                    return false;
                }
                hasSpice = true;
                continue;
            }
            if (FLOUR.test(itemstack)) {
                if (hasFlour) {
                    return false;
                }
                hasFlour = true;
                continue;
            }
            if (UPGRADE.test(itemstack)) {
                if (hasUpgrade) {
                    return false;
                }
                hasUpgrade = true;
                continue;
            }
            return false;
        }
        if (!hasLatiao) {
            return false;
        }
        boolean bl = flag1 = hasSugar || hasSalt || hasF2 || hasSpice;
        if (hasFlour && flag1 || hasCloneItem && flag1 || hasFlour && hasCloneItem || hasUpgrade && flag1 || hasUpgrade && hasCloneItem || hasUpgrade && hasFlour) {
            return false;
        }
        if (hasLatiaoSweet && hasSugar) {
            return false;
        }
        if (hasLatiaoSalted && hasSalt) {
            return false;
        }
        if (hasLatiaoF2 && hasF2) {
            return false;
        }
        if (!hasLatiaoF2 ? hasLatiaoSpice && hasSpice : hasLatiaoSpice2 && hasSpice) {
            return false;
        }
        return hasCloneItem || flag1 || hasFlour || hasUpgrade;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack latiao = ItemStack.f_41583_;
        SecondaryFlavour flavour2 = LTCSecondaryFlavours.AIR;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof ItemLatiaoBase)) continue;
            latiao = itemstack.m_41777_();
            latiao.m_41764_(1);
            break;
        }
        if (latiao.m_41619_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag compoundtag = latiao.m_41784_();
        boolean hasFlour = false;
        String spice1 = compoundtag.m_128461_("ltc2.ex_spice");
        String spice2 = compoundtag.m_128461_("ltc2.ex_spice2");
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            boolean matchF2 = false;
            for (SecondaryFlavour f2 : secondaryFlavours) {
                if (!f2.getIngredient().test(itemstack)) continue;
                matchF2 = true;
                flavour2 = f2;
                break;
            }
            if (CLONE_ITEM.test(itemstack)) {
                ItemStack cloneLatiao = latiao.m_41777_();
                cloneLatiao.m_41764_(2);
                return this.canClone(latiao) ? cloneLatiao : ItemStack.f_41583_;
            }
            if (UPGRADE.test(itemstack)) {
                if (!latiao.m_204117_(LTCTags.F_LATIAO)) {
                    return ItemStack.f_41583_;
                }
                ItemStack beforeUpgrade = latiao.m_41777_();
                beforeUpgrade.m_41764_(1);
                CompoundTag tag = beforeUpgrade.m_41784_();
                Item item = latiao.m_41720_();
                if (!(item instanceof ItemLatiaoBase)) continue;
                ItemLatiaoBase latiaoItem = (ItemLatiaoBase)item;
                int grade = latiaoItem.getLatiaoGradeValue(latiao);
                if (latiaoItem instanceof UpgradableLatiaoItem) {
                    UpgradableLatiaoItem upgradableLatiaoItem = (UpgradableLatiaoItem)latiaoItem;
                    if (grade > 5) {
                        return ItemStack.f_41583_;
                    }
                    if (grade == 5 && itemstack.m_41720_() != LTCItems.LEGENDARY_YUMMY_SAUCE.get()) {
                        return ItemStack.f_41583_;
                    }
                    if (grade < 5) {
                        beforeUpgrade = new ItemStack((ItemLike)upgradableLatiaoItem.findNextGrade(), 1);
                    } else {
                        tag.m_128379_("legendary", true);
                    }
                } else if (grade < 6) {
                    if (grade == 5 && itemstack.m_41720_() != LTCItems.LEGENDARY_YUMMY_SAUCE.get()) {
                        return ItemStack.f_41583_;
                    }
                    tag.m_128405_("LatiaoGradeValue", grade + 1);
                }
                beforeUpgrade.m_41751_(tag);
                return beforeUpgrade;
            }
            if (SUGAR.test(itemstack)) {
                if (latiao.m_204117_(LTCTags.CNOT_SUGAR) || !latiao.m_204117_(LTCTags.F_LATIAO)) {
                    return ItemStack.f_41583_;
                }
                int sweetValue = this.getSugarValue(itemstack);
                compoundtag.m_128405_("ltc2.sweet", Math.max(compoundtag.m_128451_("ltc2.sweet"), sweetValue));
                continue;
            }
            if (SALT.test(itemstack)) {
                if (latiao.m_204117_(LTCTags.CNOT_SALT) || !latiao.m_204117_(LTCTags.F_LATIAO)) {
                    return ItemStack.f_41583_;
                }
                int saltValue = this.getSaltValue(itemstack);
                compoundtag.m_128405_("ltc2.salted", Math.max(compoundtag.m_128451_("ltc2.salted"), saltValue));
                continue;
            }
            if (matchF2) {
                if (latiao.m_204117_(LTCTags.F_LATIAO)) {
                    compoundtag.m_128359_("ltc2.secondary_flavour", flavour2.getRegistryName());
                    continue;
                }
                return ItemStack.f_41583_;
            }
            if (SPICE.test(itemstack) || !latiao.m_204117_(LTCTags.F_LATIAO)) {
                String spiceName = itemstack.m_41778_();
                if (LTCStringHelper.getPowderNameFromLatiao(latiao.m_41778_()).contains(spiceName)) {
                    return ItemStack.f_41583_;
                }
                if (latiao.m_41778_().contains("underground_oil") && spiceName.contains("underground_oil")) {
                    return ItemStack.f_41583_;
                }
                if (spice1.equals(spiceName) || spice2.equals(spiceName)) {
                    return ItemStack.f_41583_;
                }
                if (spice1.isEmpty()) {
                    compoundtag.m_128359_("ltc2.ex_spice", spiceName);
                    spice1 = spiceName;
                    continue;
                }
                if (compoundtag.m_128461_("ltc2.secondary_flavour").equals("minty")) {
                    if (spice2.isEmpty()) {
                        compoundtag.m_128359_("ltc2.ex_spice2", spiceName);
                        continue;
                    }
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (!FLOUR.test(itemstack)) continue;
            hasFlour = true;
        }
        if (hasFlour) {
            boolean hasEffects;
            boolean bl = hasEffects = compoundtag.m_128441_("ltc2.sweet") || compoundtag.m_128441_("ltc2.salted") || compoundtag.m_128441_("ltc2.secondary_flavour") || compoundtag.m_128441_("ltc2.ex_spice") || compoundtag.m_128441_("ltc2.ex_spice2");
            if (hasEffects) {
                compoundtag.m_128473_("ltc2.sweet");
                compoundtag.m_128473_("ltc2.salted");
                compoundtag.m_128473_("ltc2.secondary_flavour");
                compoundtag.m_128473_("ltc2.ex_spice");
                compoundtag.m_128473_("ltc2.ex_spice2");
            } else {
                return ItemStack.f_41583_;
            }
        }
        latiao.m_41751_(compoundtag);
        return latiao;
    }

    private int getSugarValue(ItemStack stack) {
        int sugarValue = 0;
        if (stack.m_150930_(Items.f_42501_)) {
            sugarValue = 1;
        } else if (stack.m_150930_(Items.f_42787_)) {
            sugarValue = 2;
        }
        return sugarValue;
    }

    private int getSaltValue(ItemStack stack) {
        int saltValue = 0;
        if (stack.m_204117_(LTCTags.F_SALT) && !stack.m_150930_((Item)LTCItems.REFINED_SALT.get())) {
            saltValue = 1;
        } else if (stack.m_150930_((Item)LTCItems.REFINED_SALT.get())) {
            saltValue = 2;
        }
        return saltValue;
    }

    public static void setExtraSpices(String modid, String name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name));
        if (item != null) {
            spices.add(item);
        }
    }

    public NonNullList<ItemStack> getExtraSpices() {
        NonNullList list = NonNullList.m_122779_();
        if (spices != null) {
            for (Item item : spices) {
                ItemStack stack = new ItemStack((ItemLike)item);
                stack.m_41764_(1);
                list.add((Object)stack);
            }
        }
        return list;
    }

    public boolean m_8004_(int row, int column) {
        return row * column >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LTCRecipes.FLAVOURING_CRAFTING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)LTCRecipes.FLAVOURING_TYPE.get();
    }

    private boolean canClone(ItemStack stack) {
        boolean flag = true;
        Item item = stack.m_41720_();
        if (item instanceof ItemLatiaoBase) {
            ItemLatiaoBase latiao = (ItemLatiaoBase)item;
            if (latiao.getLatiaoGradeValue(stack) > 5) {
                flag = false;
            }
            if (latiao instanceof ILegendaryFeastLatiao) {
                flag = false;
            }
            if (stack.m_41782_() && stack.m_41783_().m_128471_("legendary")) {
                flag = false;
            }
        }
        return flag;
    }
}

