/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting;

import com.doggystudio.chirencqr.ltc.server.registry.LTCBlocks;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LatiaoOvenRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final String category;
    protected final Ingredient ingredient;
    @Nullable
    protected final Ingredient mainsp;
    @Nullable
    protected final Ingredient extrasp;
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;
    protected final int mainSpiceCount;
    protected final int extraSpiceCount;
    public static final int DEFAULT_SPICE_COUNT = 1;
    public static final int COOKING_TIME = 150;

    public LatiaoOvenRecipe(ResourceLocation id, String group, String category, Ingredient ingredient, @Nullable Ingredient mainsp, @Nullable Ingredient extrasp, ItemStack result, float experience, int cookingTime) {
        this(id, group, category, ingredient, mainsp, extrasp, result, experience, cookingTime, 1, 1);
    }

    public LatiaoOvenRecipe(ResourceLocation id, String group, String category, Ingredient ingredient, @Nullable Ingredient mainsp, @Nullable Ingredient extrasp, ItemStack result, float experience, int cookingTime, int mainSpiceCount, int extraSpiceCount) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.ingredient = ingredient;
        this.mainsp = mainsp;
        this.extrasp = extrasp;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.mainSpiceCount = mainSpiceCount;
        this.extraSpiceCount = extraSpiceCount;
    }

    public int getMainSpiceCount() {
        return this.mainSpiceCount;
    }

    public int getExtraSpiceCount() {
        return this.extraSpiceCount;
    }

    public boolean m_5818_(Container container, Level level) {
        return !(!this.ingredient.test(container.m_8020_(0)) || this.mainsp != null && !this.mainsp.test(container.m_8020_(1)) || this.extrasp != null && !this.extrasp.test(container.m_8020_(2)));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        int mainSpiceContainerCount = container.m_8020_(1).m_41613_();
        int extraSpiceContainerCount = container.m_8020_(2).m_41613_();
        if (mainSpiceContainerCount >= this.mainSpiceCount) {
            if (this.extrasp != null && extraSpiceContainerCount >= this.extraSpiceCount) {
                return this.result.m_41777_();
            }
            if (this.extrasp == null && extraSpiceContainerCount > 0) {
                return ItemStack.f_41583_;
            }
            if (this.extrasp == null) {
                return this.result.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)LTCRecipes.LATIAO_OVEN_SERIALIZER.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)LTCBlocks.LATIAO_OVEN.get());
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        if (this.mainsp != null) {
            list.add((Object)this.mainsp);
        }
        if (this.extrasp != null) {
            list.add((Object)this.extrasp);
        }
        return list;
    }

    public NonNullList<ItemStack> getMainSpiceItemStacks() {
        NonNullList list = NonNullList.m_122779_();
        if (this.mainsp != null) {
            for (ItemStack stack : this.mainsp.m_43908_()) {
                ItemStack mainStack = stack.m_41777_();
                mainStack.m_41764_(this.mainSpiceCount);
                list.add((Object)mainStack);
            }
        }
        return list;
    }

    public NonNullList<ItemStack> getExtraSpiceItemStacks() {
        NonNullList list = NonNullList.m_122779_();
        if (this.extrasp != null) {
            for (ItemStack stack : this.extrasp.m_43908_()) {
                ItemStack extraStack = stack.m_41777_();
                extraStack.m_41764_(this.extraSpiceCount);
                list.add((Object)extraStack);
            }
        }
        return list;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public String getCategory() {
        return this.category;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)LTCRecipes.LATIAO_OVEN_TYPE.get();
    }
}

