/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.menu;

import com.doggystudio.chirencqr.ltc.server.block.entity.LatiaoOvenBlockEntity;
import com.doggystudio.chirencqr.ltc.server.registry.LTCContainers;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class LatiaoOvenMenu
extends RecipeBookMenu<Container> {
    private final Container container;
    private final ContainerData data;
    protected final Level level;
    public static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    public static final int SLOT_COUNT = 5;
    public static final int DATA_COUNT = 4;

    public LatiaoOvenMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(4));
    }

    public LatiaoOvenMenu(int id, Inventory inventory, Container container, ContainerData data) {
        super((MenuType)LTCContainers.LATIAO_OVEN_MENU.get(), id);
        this.container = container;
        this.data = data;
        this.level = inventory.f_35978_.m_9236_();
        this.m_38897_(new Slot(this.container, 0, 21, 19));
        this.m_38897_(new Slot(this.container, 1, 39, 19));
        this.m_38897_(new Slot(this.container, 2, 57, 19));
        this.m_38897_(new LatiaoOvenFuelSlot(this, this.container, 3, 39, 55));
        this.m_38897_(new LatiaoOvenResultSlot(inventory.f_35978_, this.container, 4, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 150));
        }
        this.m_38884_(this.data);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 4) {
                if (!this.m_38903_(itemstack1, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != 3 && index != 0 && index != 1 && index != 2 ? (this.canSmelt(itemstack1) ? !this.m_38903_(itemstack1, 0, 3, false) : (this.isFuel(itemstack1) ? !this.m_38903_(itemstack1, 3, 4, false) : (index >= 5 && index < 32 ? !this.m_38903_(itemstack1, 32, 41, false) : index >= 32 && index < 41 && !this.m_38903_(itemstack1, 5, 32, false)))) : !this.m_38903_(itemstack1, 5, 41, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmelt(ItemStack itemStack) {
        return this.level.m_7465_().m_44015_((RecipeType)LTCRecipes.LATIAO_OVEN_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.level).isPresent();
    }

    public boolean isFuel(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)((RecipeType)LTCRecipes.LATIAO_OVEN_TYPE.get())) > 0;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public void m_5816_(StackedContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).m_5809_(contents);
        }
    }

    public void m_6650_() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
        this.m_38853_(1).m_5852_(ItemStack.f_41583_);
        this.m_38853_(2).m_5852_(ItemStack.f_41583_);
        this.m_38853_(4).m_5852_(ItemStack.f_41583_);
    }

    public int getBurnProgress() {
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.m_6413_(0) * 13 / i;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean m_6032_(Recipe<? super Container> recipe) {
        return recipe.m_5818_(this.container, this.level);
    }

    public int m_6636_() {
        return 4;
    }

    public int m_6635_() {
        return 1;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 5;
    }

    public RecipeBookType m_5867_() {
        return LTCRecipes.LATIAO_OVEN;
    }

    public boolean m_142157_(int flag) {
        return flag != 3;
    }

    static class LatiaoOvenFuelSlot
    extends Slot {
        private final LatiaoOvenMenu menu;

        public LatiaoOvenFuelSlot(LatiaoOvenMenu menu, Container container, int slot, int x, int y) {
            super(container, slot, x, y);
            this.menu = menu;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return this.menu.isFuel(itemStack);
        }

        public int m_5866_(ItemStack itemStack) {
            return super.m_5866_(itemStack);
        }
    }

    static class LatiaoOvenResultSlot
    extends Slot {
        private final Player player;
        private int removeCount;

        public LatiaoOvenResultSlot(Player player, Container container, int slot, int x, int y) {
            super(container, slot, x, y);
            this.player = player;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public ItemStack m_6201_(int count) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(count, this.m_7993_().m_41613_());
            }
            return super.m_6201_(count);
        }

        public void m_142406_(Player player, ItemStack itemStack) {
            this.m_5845_(itemStack);
            super.m_142406_(player, itemStack);
        }

        protected void m_7169_(ItemStack itemStack, int count) {
            this.removeCount += count;
            this.m_5845_(itemStack);
        }

        protected void m_5845_(ItemStack itemStack) {
            Container container;
            itemStack.m_41678_(this.player.m_9236_(), this.player, this.removeCount);
            if (this.player instanceof ServerPlayer && (container = this.f_40218_) instanceof LatiaoOvenBlockEntity) {
                LatiaoOvenBlockEntity latiaoOvenBlockEntity = (LatiaoOvenBlockEntity)container;
                latiaoOvenBlockEntity.awardUsedRecipesAndPopExperience((ServerPlayer)this.player);
            }
            this.removeCount = 0;
            ForgeEventFactory.firePlayerSmeltedEvent((Player)this.player, (ItemStack)itemStack);
        }
    }
}

