/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.DamageableToolShapelessRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class DamageableToolShapelessSerializer<T extends DamageableToolShapelessRecipe>
implements RecipeSerializer<T> {
    private final Creator<T> factory;

    public DamageableToolShapelessSerializer(Creator<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
        NonNullList<Ingredient> ingredients = DamageableToolShapelessSerializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (!json.has("tool")) {
            throw new JsonParseException("Missing 'tool' for damageable_tool_shapeless recipe " + id);
        }
        Ingredient tool = Ingredient.m_43917_((JsonElement)json.get("tool"));
        ingredients.add((Object)tool);
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for damageable_tool_shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for damageable_tool_shapeless recipe. The maximum is 9");
        }
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return (T)((Object)((DamageableToolShapelessRecipe)((Object)this.factory.create(id, group, category, result, ingredients, tool))));
    }

    private static NonNullList<Ingredient> itemsFromJson(JsonArray jsonArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonArray.get(i), (boolean)false);
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String group = buf.m_130277_();
        CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
        int size = buf.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        ItemStack result = buf.m_130267_();
        Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buf);
        return (T)((Object)((DamageableToolShapelessRecipe)((Object)this.factory.create(id, group, category, result, (NonNullList<Ingredient>)ingredients, tool))));
    }

    public void toNetwork(FriendlyByteBuf buf, DamageableToolShapelessRecipe recipe) {
        buf.m_130070_(recipe.m_6076_());
        buf.m_130068_((Enum)CraftingBookCategory.MISC);
        buf.m_130130_(recipe.m_7527_().size());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buf);
        }
        buf.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        recipe.getToolIngredient().m_43923_(buf);
    }

    public static interface Creator<T extends Recipe<?>> {
        public T create(ResourceLocation var1, String var2, CraftingBookCategory var3, ItemStack var4, NonNullList<Ingredient> var5, Ingredient var6);
    }
}

