/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.ExtraSpiceCustomRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraSpiceCustomSerializer<T extends ExtraSpiceCustomRecipe>
implements RecipeSerializer<T> {
    private final Creator<T> factory;
    private static final Set<String> VALID_DURATION_BASED_VALUES = Set.of("DEFAULT", "ADDITION", "ALWAYS", "POW2_MINUS1");

    public ExtraSpiceCustomSerializer(Creator<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation id, JsonObject json) {
        ItemStack itemstack;
        if (json.get("item").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
        } else {
            String item = GsonHelper.m_13906_((JsonObject)json, (String)"item");
            ResourceLocation resourcelocation = new ResourceLocation(item);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Extra Spice Item: " + item + " does not exist")));
        }
        ArrayList<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance> customEffects = new ArrayList<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance>();
        if (json.has("effects") && json.get("effects").isJsonArray()) {
            JsonArray effectsArray = json.getAsJsonArray("effects");
            for (int i = 0; i < effectsArray.size(); ++i) {
                float probability;
                int amplifier;
                JsonObject effectObj = effectsArray.get(i).getAsJsonObject();
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectObj.get("id").getAsString()));
                if (effect == null) {
                    throw new JsonParseException("Invalid effect ID: " + effectObj.get("id").getAsString());
                }
                int n = amplifier = effectObj.has("amplifier") ? effectObj.get("amplifier").getAsInt() : 0;
                if (amplifier < 0 || amplifier > 255) {
                    throw new JsonParseException("Amplifier out of range (0-255) for effect: " + effectObj.get("id").getAsString());
                }
                float f = probability = effectObj.has("probability") ? effectObj.get("probability").getAsFloat() : 1.0f;
                if (probability < 0.0f) {
                    probability = 0.0f;
                } else if (probability > 1.0f) {
                    probability = 1.0f;
                }
                int duration = 0;
                if (effectObj.has("duration") && effectObj.has("seconds")) {
                    throw new JsonParseException("Effect cannot have both duration and seconds: " + effectObj.get("id").getAsString());
                }
                if (effectObj.has("duration")) {
                    duration = effectObj.get("duration").getAsInt();
                } else if (effectObj.has("seconds")) {
                    duration = effectObj.get("seconds").getAsInt() * 20;
                }
                if (duration < 0) {
                    throw new JsonParseException("Duration/seconds cannot be negative for effect: " + effectObj.get("id").getAsString());
                }
                String durationBased = "DEFAULT";
                if (effectObj.has("duration_based_on_latiao_grade") && !VALID_DURATION_BASED_VALUES.contains(durationBased = effectObj.get("duration_based_on_latiao_grade").getAsString())) {
                    throw new JsonParseException(effectObj.get("duration_based_on_latiao_grade").getAsString() + " is an illegal operation. Valid values are: " + VALID_DURATION_BASED_VALUES);
                }
                customEffects.add(new ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance(new MobEffectInstance(effect, duration, amplifier), Float.valueOf(probability), durationBased));
            }
        }
        ArrayList<String> events = new ArrayList<String>();
        if (json.has("events") && json.get("events").isJsonArray()) {
            JsonArray eventsArray = json.getAsJsonArray("events");
            for (int i = 0; i < eventsArray.size(); ++i) {
                events.add(eventsArray.get(i).getAsString());
            }
        }
        return (T)((ExtraSpiceCustomRecipe)this.factory.create(id, itemstack, customEffects, events));
    }

    public void toNetwork(FriendlyByteBuf buffer, ExtraSpiceCustomRecipe recipe) {
        buffer.m_130055_(recipe.getItem());
        buffer.m_130130_(recipe.getCustomEffects().size());
        for (ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance exEffect : recipe.getCustomEffects()) {
            MobEffectInstance effectInstance = exEffect.getEffectInstance();
            String durationBasedOnLatiaoGrade = exEffect.getDurationRule();
            buffer.m_130085_(ForgeRegistries.MOB_EFFECTS.getKey((Object)effectInstance.m_19544_()));
            buffer.m_130130_(effectInstance.m_19564_());
            buffer.writeFloat(exEffect.getProbability());
            buffer.m_130130_(effectInstance.m_19557_());
            buffer.m_130070_(durationBasedOnLatiaoGrade);
        }
        buffer.m_130130_(recipe.getEvents().size());
        for (String event : recipe.getEvents()) {
            buffer.m_130070_(event);
        }
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buffer) {
        ItemStack itemstack = buffer.m_130267_();
        ArrayList<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance> customEffects = new ArrayList<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance>();
        int effectsSize = buffer.m_130242_();
        for (int i = 0; i < effectsSize; ++i) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.m_130281_());
            if (effect == null) {
                throw new IllegalArgumentException("Invalid effect in recipe from network buffer");
            }
            int amplifier = buffer.m_130242_();
            float probability = buffer.readFloat();
            int duration = buffer.m_130242_();
            String durationBasedOnLatiaoGrade = buffer.m_130277_();
            customEffects.add(new ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance(new MobEffectInstance(effect, duration, amplifier), Float.valueOf(probability), durationBasedOnLatiaoGrade));
        }
        int eventsSize = buffer.m_130242_();
        ArrayList<String> events = new ArrayList<String>();
        for (int i = 0; i < eventsSize; ++i) {
            events.add(buffer.m_130277_());
        }
        return (T)((ExtraSpiceCustomRecipe)this.factory.create(id, itemstack, customEffects, events));
    }

    public static interface Creator<T extends Recipe<?>> {
        public T create(ResourceLocation var1, ItemStack var2, List<ExtraSpiceCustomRecipe.ExtraSpiceEffectInstance> var3, List<String> var4);
    }
}

