/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.LatiaoOvenRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class LatiaoOvenSerializer<T extends LatiaoOvenRecipe>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final int defaultExtraSpiceCount;
    private final Creator<T> factory;

    public LatiaoOvenSerializer(Creator<T> creator, int cookingTime, int count) {
        this.defaultCookingTime = cookingTime;
        this.defaultExtraSpiceCount = count;
        this.factory = creator;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        ItemStack itemstack;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        String category = GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"");
        JsonArray ingredientJson = GsonHelper.m_13885_((JsonObject)json, (String)"latiao") ? GsonHelper.m_13933_((JsonObject)json, (String)"latiao") : GsonHelper.m_13930_((JsonObject)json, (String)"latiao");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
        Ingredient mainsp = null;
        Ingredient extrasp = null;
        int mainSpiceCount = 0;
        int extraSpiceCount = 0;
        if (json.has("mainsp")) {
            JsonObject mainspJson = GsonHelper.m_13930_((JsonObject)json, (String)"mainsp");
            mainsp = Ingredient.m_43917_((JsonElement)mainspJson);
            if (mainspJson.has("count")) {
                mainSpiceCount = GsonHelper.m_13824_((JsonObject)mainspJson, (String)"count", (int)this.defaultExtraSpiceCount);
            }
            if (json.has("extrasp")) {
                JsonObject extraspJson = GsonHelper.m_13930_((JsonObject)json, (String)"extrasp");
                extrasp = Ingredient.m_43917_((JsonElement)extraspJson);
                if (extraspJson.has("count")) {
                    extraSpiceCount = GsonHelper.m_13824_((JsonObject)extraspJson, (String)"count", (int)this.defaultExtraSpiceCount);
                }
            }
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String result = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(result);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float f = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int i = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        System.out.println("Parsing JSON: " + json.toString());
        return (T)((LatiaoOvenRecipe)this.factory.create(id, group, category, ingredient, mainsp, extrasp, itemstack, f, i, mainSpiceCount, extraSpiceCount));
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String group = buf.m_130277_();
        String category = buf.m_130277_();
        int ingredientSize = buf.m_130242_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient mainsp = null;
        Ingredient extrasp = null;
        if (ingredientSize > 1) {
            mainsp = Ingredient.m_43940_((FriendlyByteBuf)buf);
            if (ingredientSize > 2) {
                extrasp = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
        }
        ItemStack itemstack = buf.m_130267_();
        float xp = buf.readFloat();
        int time = buf.m_130242_();
        int mainSpiceCount = 0;
        int extraSpiceCount = 0;
        mainSpiceCount = buf.m_130242_();
        if (ingredientSize > 2) {
            extraSpiceCount = buf.m_130242_();
        }
        return (T)((LatiaoOvenRecipe)this.factory.create(id, group, category, ingredient, mainsp, extrasp, itemstack, xp, time, mainSpiceCount, extraSpiceCount));
    }

    public void toNetwork(FriendlyByteBuf buf, T recipe) {
        buf.m_130070_(((LatiaoOvenRecipe)recipe).m_6076_());
        buf.m_130070_(((LatiaoOvenRecipe)recipe).getCategory());
        buf.m_130130_(Mth.m_14045_((int)((LatiaoOvenRecipe)recipe).m_7527_().size(), (int)1, (int)3));
        for (Ingredient ingredient : ((LatiaoOvenRecipe)recipe).m_7527_()) {
            ingredient.m_43923_(buf);
        }
        buf.m_130055_(((LatiaoOvenRecipe)recipe).getResult());
        buf.writeFloat(((LatiaoOvenRecipe)recipe).getExperience());
        buf.m_130130_(((LatiaoOvenRecipe)recipe).getCookingTime());
        buf.m_130130_(((LatiaoOvenRecipe)recipe).getMainSpiceCount());
        if (((LatiaoOvenRecipe)recipe).m_7527_().size() > 2) {
            buf.m_130130_(((LatiaoOvenRecipe)recipe).getExtraSpiceCount());
        }
    }

    public static interface Creator<T extends Recipe<?>> {
        public T create(ResourceLocation var1, String var2, String var3, Ingredient var4, @Nullable Ingredient var5, @Nullable Ingredient var6, ItemStack var7, float var8, int var9, int var10, int var11);
    }
}

