/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.MillRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class MillSerializer<T extends MillRecipe>
implements RecipeSerializer<T> {
    private final int defaultMillingTime;
    private final Creator<T> factory;

    public MillSerializer(Creator<T> creator, int cookingTime) {
        this.defaultMillingTime = cookingTime;
        this.factory = creator;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        ItemStack itemstack;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        String category = GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"");
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String result = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(result);
            itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float exp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int t = GsonHelper.m_13824_((JsonObject)json, (String)"millingtime", (int)this.defaultMillingTime);
        return (T)((Object)((MillRecipe)((Object)this.factory.create(id, group, category, ingredient, itemstack, exp, t))));
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String group = buf.m_130277_();
        String category = buf.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack itemstack = buf.m_130267_();
        float exp = buf.readFloat();
        int time = buf.m_130242_();
        return (T)((Object)((MillRecipe)((Object)this.factory.create(id, group, category, ingredient, itemstack, exp, time))));
    }

    public void toNetwork(FriendlyByteBuf buf, T recipe) {
        buf.m_130070_(recipe.m_6076_());
        buf.m_130070_(((MillRecipe)((Object)recipe)).getCategory());
        ((MillRecipe)((Object)recipe)).getIngredient().m_43923_(buf);
        buf.m_130055_(((MillRecipe)((Object)recipe)).getResult());
        buf.writeFloat(recipe.m_43750_());
        buf.m_130130_(recipe.m_43753_());
    }

    public static interface Creator<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, String var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

