/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.OreifyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreifySerializer<T extends OreifyRecipe>
implements RecipeSerializer<T> {
    private final Creator<T> factory;

    public OreifySerializer(Creator<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation id, JsonObject json) {
        Block baseBlock;
        if (json.get("base_block").isJsonObject()) {
            Block block;
            base = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"base_block"));
            Item item = base.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
            } else {
                block = Blocks.f_50016_;
            }
            baseBlock = block;
        } else {
            base = GsonHelper.m_13906_((JsonObject)json, (String)"base_block");
            ResourceLocation resourceLocation = new ResourceLocation(base);
            baseBlock = (Block)BuiltInRegistries.f_256975_.m_6612_(resourceLocation).orElseThrow(() -> new JsonParseException("Block with ID '" + base + "' does not exist"));
        }
        if (!json.has("base_block")) {
            throw new JsonSyntaxException("Missing base_block, expected to find a string or object");
        }
        HashMap<Block, Integer> ores = new HashMap<Block, Integer>();
        if (json.has("ores") && json.get("ores").isJsonArray()) {
            JsonArray oresArray = json.getAsJsonArray("ores");
            for (int i = 0; i < oresArray.size(); ++i) {
                int weight;
                JsonObject oreObj = oresArray.get(i).getAsJsonObject();
                Block ore = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(oreObj.get("name").getAsString()));
                if (ore == null) {
                    throw new JsonParseException("Invalid block name: " + oreObj.get("name").getAsString());
                }
                int n = weight = oreObj.has("weight") ? oreObj.get("weight").getAsInt() : 1;
                if (weight < 0) {
                    throw new JsonParseException("Weight cannot be less than 0 " + oreObj.get("id").getAsString());
                }
                ores.put(ore, weight);
            }
        }
        return (T)((OreifyRecipe)this.factory.create(id, baseBlock, ores));
    }

    public void toNetwork(FriendlyByteBuf buffer, OreifyRecipe recipe) {
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)recipe.getBaseBlock()));
        buffer.m_130130_(recipe.getOreMap().size());
        for (Map.Entry<Block, Integer> entry : recipe.getOreMap().entrySet()) {
            buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)entry.getKey()));
            buffer.m_130130_(entry.getValue().intValue());
        }
    }

    @Nullable
    public T fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buffer) {
        Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        if (baseBlock == null) {
            baseBlock = Blocks.f_50016_;
        }
        int oreCount = buffer.m_130242_();
        HashMap<Block, Integer> ores = new HashMap<Block, Integer>();
        for (int i = 0; i < oreCount; ++i) {
            Block ore = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
            if (ore == null) {
                ore = Blocks.f_50016_;
            }
            int weight = buffer.m_130242_();
            ores.put(ore, weight);
        }
        return (T)((OreifyRecipe)this.factory.create(id, baseBlock, ores));
    }

    public static interface Creator<T extends Recipe<?>> {
        public T create(ResourceLocation var1, Block var2, Map<Block, Integer> var3);
    }
}

