/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.crafting.serializer;

import com.doggystudio.chirencqr.ltc.server.crafting.PepperTransmutationRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PepperTransmutationSerializer<T extends PepperTransmutationRecipe>
implements RecipeSerializer<T> {
    private final Creator<T> factory;

    public PepperTransmutationSerializer(Creator<T> factory) {
        this.factory = factory;
    }

    @NotNull
    public T fromJson(@NotNull ResourceLocation id, JsonObject json) {
        ItemStack output;
        JsonArray inputJson = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        Ingredient input = Ingredient.m_43917_((JsonElement)inputJson);
        if (!json.has("output")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("output").isJsonObject()) {
            output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
        } else {
            String result = GsonHelper.m_13906_((JsonObject)json, (String)"output");
            ResourceLocation resourcelocation = new ResourceLocation(result);
            output = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float exp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
        if (chance > 100 || chance < 0) {
            throw new IllegalArgumentException(output.m_41778_() + ": Chance must be between 0 and 100.");
        }
        return (T)((PepperTransmutationRecipe)this.factory.create(id, input, output, exp, chance));
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack output = buf.m_130267_();
        float exp = buf.readFloat();
        int chance = buf.m_130242_();
        return (T)((PepperTransmutationRecipe)this.factory.create(id, input, output, exp, chance));
    }

    public void toNetwork(FriendlyByteBuf buf, T recipe) {
        ((PepperTransmutationRecipe)recipe).getInput().m_43923_(buf);
        buf.m_130055_(((PepperTransmutationRecipe)recipe).getOutput());
        buf.writeFloat(((PepperTransmutationRecipe)recipe).getExp());
        buf.m_130130_(((PepperTransmutationRecipe)recipe).getChance());
    }

    public static interface Creator<T extends Recipe<?>> {
        public T create(ResourceLocation var1, Ingredient var2, ItemStack var3, float var4, int var5);
    }
}

