/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.registry.LTCEffects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BacktraceEffectEvent {
    private static final String KEY_DIMENSION = "BacktraceDimension";
    private static final String KEY_POS_X = "BacktracePosX";
    private static final String KEY_POS_Y = "BacktracePosY";
    private static final String KEY_POS_Z = "BacktracePosZ";

    @SubscribeEvent
    public static void onEffectApply(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MobEffectInstance instance = event.getEffectInstance();
            if (instance != null && instance.m_19544_() == LTCEffects.BACKTRACE.get()) {
                BacktraceEffectEvent.save(player, (ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20097_().m_7494_());
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance instance;
        if (!event.getEntity().m_9236_().f_46443_ && (instance = event.getEffectInstance()) != null) {
            BacktraceEffectEvent.doBacktrace(instance.m_19544_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance instance;
        if (!event.getEntity().m_9236_().f_46443_ && (instance = event.getEffectInstance()) != null) {
            BacktraceEffectEvent.doBacktrace(instance.m_19544_(), event.getEntity());
        }
    }

    private static void doBacktrace(MobEffect effect, LivingEntity entity) {
        if (effect == LTCEffects.BACKTRACE.get() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BacktraceData data = BacktraceEffectEvent.load(player);
            if (data != null) {
                ServerLevel targetLevel;
                ResourceKey<Level> dimensionKey = data.dimension();
                BlockPos pos = data.pos();
                MinecraftServer server = player.m_20194_();
                if (server != null && (targetLevel = server.m_129880_(dimensionKey)) != null) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, targetLevel.f_46441_.m_188501_() + 0.3f);
                    player.m_8999_(targetLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    targetLevel.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, targetLevel.f_46441_.m_188501_() + 0.3f);
                    targetLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 50, 0.5, 1.0, 0.5, 0.0);
                }
            }
            BacktraceEffectEvent.clear(player);
            for (MobEffectInstance activeEffect : player.m_21220_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), activeEffect));
            }
        }
    }

    public static void save(ServerPlayer player, ResourceKey<Level> dimension, BlockPos pos) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128359_(KEY_DIMENSION, dimension.m_135782_().toString());
        tag.m_128405_(KEY_POS_X, pos.m_123341_());
        tag.m_128405_(KEY_POS_Y, pos.m_123342_());
        tag.m_128405_(KEY_POS_Z, pos.m_123343_());
    }

    @Nullable
    public static BacktraceData load(ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_(KEY_DIMENSION)) {
            return null;
        }
        ResourceLocation dimId = new ResourceLocation(tag.m_128461_(KEY_DIMENSION));
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId);
        BlockPos pos = new BlockPos(tag.m_128451_(KEY_POS_X), tag.m_128451_(KEY_POS_Y), tag.m_128451_(KEY_POS_Z));
        return new BacktraceData((ResourceKey<Level>)dimension, pos);
    }

    public static void clear(ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128473_(KEY_DIMENSION);
        tag.m_128473_(KEY_POS_X);
        tag.m_128473_(KEY_POS_Y);
        tag.m_128473_(KEY_POS_Z);
    }

    public record BacktraceData(ResourceKey<Level> dimension, BlockPos pos) {
    }
}

