/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.misc.LTCItemHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CleanseLatiaoEvent {
    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        for (Item cleanseLatiao : LTCItemHelper.CLEANSE_LATIAO_LIST) {
            Level level;
            if (!stack.m_150930_(cleanseLatiao)) continue;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if ((level = player.m_9236_()) instanceof ServerLevel) {
                ZombieHorse zombieHorse;
                Horse horse;
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity instanceof ZombieVillager) {
                    ZombieVillager zombieVillager = (ZombieVillager)entity;
                    CleanseLatiaoEvent.instantConvertZombieVillager(zombieVillager, serverLevel, player);
                } else if (entity instanceof ZombifiedPiglin) {
                    ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)entity;
                    Piglin piglin = (Piglin)zombifiedPiglin.m_21406_(EntityType.f_20511_, false);
                    if (piglin != null) {
                        piglin.m_34670_(true);
                        CleanseLatiaoEvent.afterConvert((LivingEntity)zombifiedPiglin, (LivingEntity)piglin, serverLevel, player);
                    }
                } else if (entity instanceof Zoglin) {
                    Zoglin zoglin = (Zoglin)entity;
                    Hoglin hoglin = (Hoglin)zoglin.m_21406_(EntityType.f_20456_, false);
                    if (hoglin != null) {
                        hoglin.m_34564_(true);
                        CleanseLatiaoEvent.afterConvert((LivingEntity)zoglin, (LivingEntity)hoglin, serverLevel, player);
                    }
                } else if (entity instanceof ZombieHorse && (horse = (Horse)(zombieHorse = (ZombieHorse)entity).m_21406_(EntityType.f_20457_, false)) != null) {
                    if (zombieHorse.m_8077_()) {
                        horse.m_6593_(zombieHorse.m_7770_());
                        horse.m_20340_(zombieHorse.m_20151_());
                    }
                    horse.m_30651_(zombieHorse.m_30614_());
                    horse.m_146762_(zombieHorse.m_146764_());
                    horse.m_21530_();
                    CleanseLatiaoEvent.afterConvert((LivingEntity)zombieHorse, (LivingEntity)horse, serverLevel, player);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
    }

    private static void instantConvertZombieVillager(ZombieVillager zombie, ServerLevel level, Player player) {
        Villager villager = (Villager)zombie.m_21406_(EntityType.f_20492_, false);
        if (villager == null) {
            return;
        }
        villager.m_34375_(zombie.m_7141_());
        villager.m_35546_(zombie.m_149889_());
        if (player instanceof ServerPlayer) {
            level.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager);
        }
        CleanseLatiaoEvent.afterConvert((LivingEntity)zombie, (LivingEntity)villager, level, player);
    }

    private static void afterConvert(LivingEntity entity, LivingEntity outcome, ServerLevel level, Player player) {
        if (outcome == null) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            LTCTriggers.PURIFYING_ZOMBIE.trigger(sp);
        }
        level.m_5898_(null, 1027, entity.m_20183_(), 0);
        for (int i = 0; i < 20; ++i) {
            double dx = entity.m_217043_().m_188583_() * 0.02;
            double dy = entity.m_217043_().m_188583_() * 0.02;
            double dz = entity.m_217043_().m_188583_() * 0.02;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + entity.m_217043_().m_188500_() * (double)entity.m_20206_(), entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_(), 1, dx, dy, dz, 1.0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)entity, (LivingEntity)outcome);
    }
}

