/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.network.LTCNetworkHandler;
import com.doggystudio.chirencqr.ltc.server.network.ParticleEnderChainPacket;
import com.doggystudio.chirencqr.ltc.server.registry.LTCDamageTypes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEffects;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnderChainEffectEvent {
    @SubscribeEvent
    public void onPlayerAttack(LivingDamageEvent event) {
        Player player;
        Entity entity;
        if (!event.getEntity().m_9236_().f_46443_ && (entity = event.getSource().m_7639_()) instanceof Player && (player = (Player)entity).m_21023_((MobEffect)LTCEffects.ENDER_CHAIN.get())) {
            DamageSource CHAIN_DAMAGE = LTCDamageTypes.getDamageSource(event.getEntity().m_9236_(), LTCDamageTypes.ENDER_CHAIN, (LivingEntity)player);
            int lv = player.m_21124_((MobEffect)LTCEffects.ENDER_CHAIN.get()).m_19564_() + 1;
            if (this.hasMobInRange(event.getEntity())) {
                List<LivingEntity> closestMobs = this.findClosestMob(event.getEntity());
                if (!event.getSource().m_276093_(LTCDamageTypes.ENDER_CHAIN)) {
                    if (lv > 1) {
                        float damage = event.getAmount() * 0.25f * (float)(lv - 1);
                        damage = Math.min(damage, event.getAmount());
                        int i = 0;
                        for (LivingEntity nearbyMob : closestMobs) {
                            nearbyMob.m_6469_(CHAIN_DAMAGE, damage);
                            this.copyDebuffs(event.getEntity(), nearbyMob, lv);
                            this.chain(event.getEntity().m_9236_(), event.getEntity(), nearbyMob);
                            if (++i != lv) continue;
                            break;
                        }
                    } else {
                        LivingEntity closestMob = this.findClosestMob(event.getEntity()).get(0);
                        closestMob.m_6469_(CHAIN_DAMAGE, event.getAmount() / 10.0f);
                        this.copyDebuffs(event.getEntity(), closestMob, lv);
                        this.chain(event.getEntity().m_9236_(), event.getEntity(), closestMob);
                    }
                }
            }
        }
    }

    private boolean hasMobInRange(LivingEntity entity) {
        double range = 7.0;
        Vec3 pos = EnderChainEffectEvent.getMobCenter(entity);
        AABB searchArea = new AABB(pos.f_82479_ - range, pos.f_82480_ - range, pos.f_82481_ - range, pos.f_82479_ + range, pos.f_82480_ + range, pos.f_82481_ + range);
        return !entity.m_9236_().m_6443_(LivingEntity.class, searchArea, e -> e != entity && this.isMatchedMob((LivingEntity)e)).isEmpty();
    }

    private List<LivingEntity> findClosestMob(LivingEntity entity) {
        Vec3 pos = EnderChainEffectEvent.getMobCenter(entity);
        double range = 7.0;
        AABB searchArea = new AABB(pos.f_82479_ - range, pos.f_82480_ - range, pos.f_82481_ - range, pos.f_82479_ + range, pos.f_82480_ + range, pos.f_82481_ + range);
        List nearbyMobs = entity.m_9236_().m_6443_(LivingEntity.class, searchArea, e -> e != entity && this.isMatchedMob((LivingEntity)e));
        nearbyMobs.sort(Comparator.comparingDouble(a -> a.m_20238_(pos)));
        return nearbyMobs.subList(0, Math.min(nearbyMobs.size(), 3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMatchedMob(LivingEntity e) {
        if (!e.m_6084_()) return false;
        if (!(e instanceof Player)) {
            if (e.m_6688_() instanceof Player) return false;
            if (e == e.m_275832_()) return false;
            return true;
        }
        Player player = (Player)e;
        return false;
    }

    private static Vec3 getMobCenter(LivingEntity entity) {
        AABB box = entity.m_20191_();
        double x = box.f_82288_ + box.f_82291_;
        double y = box.f_82289_ + box.f_82292_;
        double z = box.f_82290_ + box.f_82293_;
        return new Vec3(x / 2.0, y / 2.0, z / 2.0);
    }

    private void chain(Level level, LivingEntity mob1, LivingEntity mob2) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Vec3 pos1 = EnderChainEffectEvent.getMobCenter(mob1);
        Vec3 pos2 = EnderChainEffectEvent.getMobCenter(mob2);
        mob1.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 25));
        mob2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 25));
        ParticleEnderChainPacket packet = new ParticleEnderChainPacket(pos1, pos2);
        LTCNetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> mob1), (Object)packet);
    }

    private void copyDebuffs(LivingEntity mob1, LivingEntity mob2, int enderChainLevel) {
        for (MobEffectInstance debuff : mob1.m_21220_()) {
            if (debuff.m_19544_().m_19486_()) continue;
            int duration = enderChainLevel > 1 ? debuff.m_19557_() : debuff.m_19557_() / 2;
            mob2.m_7292_(new MobEffectInstance(debuff.m_19544_(), duration, debuff.m_19564_()));
        }
    }
}

