/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.config.CommonConfig;
import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCDamageTypes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEffects;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LTCCommonEvents {
    private static final Set<UUID> playersNeedParticles = new HashSet<UUID>();

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            MobEffect bloodSucker = (MobEffect)LTCEffects.BLOOD_SUCKER.get();
            if (event.getAmount() > 0.0f && attacker.m_21023_(bloodSucker)) {
                int effectLevel = attacker.m_21124_(bloodSucker).m_19564_();
                float attckerHealth = attacker.m_21223_();
                float attckerMaxHealth = attacker.m_21233_();
                attacker.m_5634_(LTCMathHelper.suckingBlood(attckerMaxHealth, attckerHealth, effectLevel, event.getAmount()));
            }
            MobEffect rage = (MobEffect)LTCEffects.RAGE.get();
            if (event.getAmount() > 0.0f && attacker.m_21023_(rage)) {
                int effectLevel = attacker.m_21124_(rage).m_19564_() + 1;
                event.getEntity().m_20254_(effectLevel * 2);
                if (attacker.m_6060_() || attacker.m_21023_((MobEffect)LTCEffects.HOT.get())) {
                    float damage = event.getAmount();
                    event.setAmount(damage * 2.0f);
                }
            }
            MobEffect cryoshield = (MobEffect)LTCEffects.CRYOSHIELD.get();
            if (event.getEntity().m_21023_(cryoshield)) {
                int cryoshieldLevel = event.getEntity().m_21124_(cryoshield).m_19564_() + 1;
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100 * cryoshieldLevel, cryoshieldLevel));
                if ((event.getSource().m_276093_(LTCDamageTypes.HOT) || event.getSource().m_269533_(DamageTypeTags.f_268745_) || event.getSource().m_269533_(DamageTypeTags.f_268524_)) && LTCMathHelper.drawNumber(50 + cryoshieldLevel * 5)) {
                    event.getSource().m_7639_().m_6469_(event.getSource(), event.getAmount() * 0.3f + 0.02f * (float)cryoshieldLevel);
                }
            }
        }
        if (event.getEntity().m_6095_().m_204039_(LTCTags.HOT_DAMAGE_IMMUNE) && event.getSource().m_276093_(LTCDamageTypes.HOT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            boolean flag2 = false;
            MobEffect benedictio = (MobEffect)LTCEffects.BENEDICTION.get();
            if (player.m_21023_(benedictio)) {
                if (event.getSource().m_276093_(LTCDamageTypes.HOT) || event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                    flag2 = true;
                }
                if (!player.m_9236_().f_46443_) {
                    if (!flag2) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.ltc2.undying_benediction.rebirth"));
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"advancement.ltc2.undying_dust_burning.desc").m_130940_(ChatFormatting.DARK_RED));
                    }
                    HashSet<MobEffect> effectsNeedRemove = new HashSet<MobEffect>();
                    for (MobEffectInstance effectInstance : player.m_21220_()) {
                        MobEffect effect = effectInstance.m_19544_();
                        if (effect.m_19486_()) continue;
                        effectsNeedRemove.add(effect);
                    }
                    effectsNeedRemove.forEach(arg_0 -> ((Player)player).m_21195_(arg_0));
                    player.m_21195_(benedictio);
                    player.m_21153_(player.m_21233_());
                    LTCTriggers.UNDYING_DUST.trigger((ServerPlayer)player);
                    if (flag2) {
                        LTCTriggers.UNDYING_DUST_BURNING.trigger((ServerPlayer)player);
                    }
                    playersNeedParticles.add(player.m_20148_());
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player.m_9236_().f_46443_ && playersNeedParticles.contains(player.m_20148_())) {
            player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_() * 0.2f + 0.9f);
            Minecraft.m_91087_().f_91061_.m_107332_((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 30);
            playersNeedParticles.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        MobEffect exp_plunderer;
        Player player;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21023_(exp_plunderer = (MobEffect)LTCEffects.EXP_PLUNDERER.get())) {
            int amplifier = player.m_21124_(exp_plunderer).m_19564_();
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)living.m_9236_()), (Vec3)living.m_20182_(), (int)LTCMathHelper.expPlunderer(2, amplifier));
        }
        if (((Boolean)CommonConfig.UNDEAD_DROP.get()).booleanValue() && living.m_6336_() == MobType.f_21641_ && event.getSource().m_276093_(LTCDamageTypes.HOT)) {
            boolean flag = true;
            ItemStack sauce = new ItemStack((ItemLike)LTCItems.YUMMY_SAUCE.get(), 1);
            ItemStack legendarySauce = new ItemStack((ItemLike)LTCItems.LEGENDARY_YUMMY_SAUCE.get(), 1);
            if (LTCMathHelper.drawNumber(5)) {
                living.m_19983_(legendarySauce);
                flag = false;
            }
            if (flag && LTCMathHelper.drawNumber(20)) {
                living.m_19983_(sauce);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        Entity entity;
        MobEffect curse = (MobEffect)LTCEffects.CURSE.get();
        if (event.getEntity().m_21023_(curse)) {
            event.getEntity().m_21153_(2.0f);
        }
        if ((entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (event.getEntity().m_21205_().m_204117_(LTCTags.HOTAURUM_ITEMS) && LTCMathHelper.drawNumber(20)) {
                target.m_7292_(new MobEffectInstance((MobEffect)LTCEffects.HOT.get(), 100));
            }
        }
    }

    @SubscribeEvent
    public static void onPotionApply(MobEffectEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (event.getEffectInstance() != null && !event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof Player && (player = (Player)livingEntity).m_21023_((MobEffect)LTCEffects.PURIFYING.get()) && !event.getEffectInstance().m_19544_().m_19486_()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerTicks(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_21023_((MobEffect)LTCEffects.LAVA_WALKER.get())) {
            BlockPos belowPlayer = player.m_20183_().m_7495_();
            BlockState blockState = player.m_9236_().m_8055_(belowPlayer);
            if (blockState.m_60713_(Blocks.f_49991_)) {
                player.m_9236_().m_46597_(belowPlayer, Blocks.f_50730_.m_49966_());
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)belowPlayer.m_123341_() + 0.5f), (double)belowPlayer.m_123342_(), (double)((float)belowPlayer.m_123343_() + 0.5f), 1.0, 1.0, 1.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerContainerChanged(PlayerContainerEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            for (ItemStack latiao : event.getContainer().m_38927_()) {
                CompoundTag tag;
                String spice;
                if (!(latiao.m_41720_() instanceof ItemLatiaoBase) || !latiao.m_41782_() || !(spice = (tag = latiao.m_41783_()).m_128461_("ltc2.ex_spice")).equals(Items.f_42735_.m_5524_())) continue;
                LTCTriggers.WELOONG.trigger((ServerPlayer)event.getEntity());
            }
        }
    }
}

