/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.config.CommonConfig;
import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEnchantments;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LatiaoMendingEnchantmentEvent {
    @SubscribeEvent
    public static void onEatFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LatiaoMendingEnchantmentEvent.consumingLatiao(event.getItem(), player);
        }
    }

    private static void consumingLatiao(ItemStack consume, Player player) {
        Item item = consume.m_41720_();
        if (!(item instanceof ItemLatiaoBase)) {
            return;
        }
        ItemLatiaoBase latiao = (ItemLatiaoBase)item;
        int grade = latiao.getLatiaoGradeValue(consume);
        ItemStack repair = player.m_6844_(EquipmentSlot.OFFHAND);
        ItemStack[] armor = new ItemStack[]{player.m_6844_(EquipmentSlot.HEAD), player.m_6844_(EquipmentSlot.CHEST), player.m_6844_(EquipmentSlot.LEGS), player.m_6844_(EquipmentSlot.FEET)};
        LatiaoMendingEnchantmentEvent.repairItem(repair, grade);
        if (((Boolean)CommonConfig.LATIAO_MENDING_ARMOR.get()).booleanValue()) {
            for (ItemStack equipment : armor) {
                LatiaoMendingEnchantmentEvent.repairItem(equipment, grade);
            }
        }
    }

    private static void repairItem(ItemStack repair, int grade) {
        int level;
        boolean isHotaurumItem = false;
        if (repair.m_204117_(LTCTags.HOTAURUM_ITEMS) || repair.m_150930_((Item)LTCItems.EVIL_SWORD.get())) {
            isHotaurumItem = true;
        }
        if ((level = repair.getEnchantmentLevel((Enchantment)LTCEnchantments.LATIAO_MENDING.get())) > 0 && repair.m_41763_()) {
            int currentDamage = repair.m_41773_();
            int m = grade >= 4 ? grade * 3 : grade * 2;
            m = m * level + repair.m_41776_() % 10;
            m = isHotaurumItem ? m + grade * level : m;
            int repairValue = Math.min(currentDamage, m);
            repair.m_41721_(currentDamage - repairValue);
        }
    }
}

