/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.event;

import com.doggystudio.chirencqr.ltc.server.crafting.PepperTransmutationRecipe;
import com.doggystudio.chirencqr.ltc.server.misc.LTCMathHelper;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCRecipes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltc2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PepperTransmutationEvent {
    private static List<PepperTransmutationRecipe> list = new ArrayList<PepperTransmutationRecipe>();
    private static boolean isToss;

    @SubscribeEvent
    public static void onPlayerLoggin(PlayerEvent.PlayerLoggedInEvent event) {
        list = event.getEntity().m_9236_().m_7465_().m_44013_((RecipeType)LTCRecipes.PEPPER_TRANS_TYPE.get());
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        for (PepperTransmutationRecipe recipe : list) {
            if (event.getEntity().m_9236_().f_46443_ || !recipe.getInput().test(event.getEntity().m_32055_())) continue;
            isToss = false;
            break;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.PlayerTickEvent event) {
        Level world = event.player.m_9236_();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (!isToss) {
            block0: for (PepperTransmutationRecipe recipe : list) {
                Ingredient input = recipe.getInput();
                List itemEntities = world.m_45976_(ItemEntity.class, event.player.m_20191_().m_82400_(4.0));
                for (ItemEntity itemEntity : itemEntities) {
                    BlockPos landedPos;
                    if (!input.test(itemEntity.m_32055_()) || !PepperTransmutationEvent.isValidTransmutationArea(world, landedPos = itemEntity.m_20183_())) continue;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            if (dx == 0 && dz == 0) continue;
                            BlockPos checkPos = landedPos.m_7918_(dx, 0, dz);
                            BlockPos dirtPos = landedPos.m_7918_(dx, -1, dz);
                            for (int i = 0; i < 10; ++i) {
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 1.0 + (double)i * 0.1, (double)checkPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                            }
                            world.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                            world.m_7731_(dirtPos, Blocks.f_50546_.m_49966_(), 3);
                            world.m_7731_(checkPos, Blocks.f_50036_.m_49966_(), 3);
                        }
                    }
                    boolean isSuccessful = LTCMathHelper.drawNumber(recipe.getChance());
                    if (isSuccessful) {
                        ItemStack output = recipe.getOutput();
                        ItemStack entityStack = itemEntity.m_32055_();
                        entityStack.m_41774_(1);
                        if (entityStack.m_41613_() > 0) {
                            itemEntity.m_32045_(entityStack);
                        }
                        ItemEntity outputEntity = new ItemEntity(world, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), output);
                        world.m_7967_((Entity)outputEntity);
                        LTCTriggers.PEPPER_TRANSMUTATION.trigger((ServerPlayer)event.player);
                        if (output.m_150930_((Item)LTCItems.HOTAURUM_UPGRADE.get())) {
                            LTCTriggers.HOTAURUM_TEMPLATE.trigger((ServerPlayer)event.player);
                        }
                        PepperTransmutationEvent.createExp(serverWorld, event.player.m_20182_(), recipe.getExp());
                        continue block0;
                    }
                    PepperTransmutationEvent.afterTransmutating(world, landedPos, isSuccessful);
                }
            }
            isToss = false;
        }
    }

    private static boolean isValidTransmutationArea(Level world, BlockPos lavaPos) {
        BlockState state;
        BlockPos checkPos;
        int dz;
        int dx;
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                boolean flag;
                checkPos = lavaPos.m_7918_(dx, -1, dz);
                state = world.m_8055_(checkPos);
                if (dx == 0 && dz == 0) {
                    if (state.m_60734_() == Blocks.f_49990_) continue;
                    return false;
                }
                boolean bl = flag = state.m_60734_() != Blocks.f_50440_ && state.m_60734_() != Blocks.f_50093_ && state.m_60734_() != Blocks.f_50493_ && state.m_60734_() != Blocks.f_49993_ && state.m_60734_() != Blocks.f_49992_ && state.m_60734_() != Blocks.f_50135_ && state.m_60734_() != Blocks.f_50136_ && state.m_60734_() != Blocks.f_50699_ && state.m_60734_() != Blocks.f_50690_ && state.m_60734_() != Blocks.f_50259_;
                if (!flag) continue;
                return false;
            }
        }
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                checkPos = lavaPos.m_7918_(dx, 0, dz);
                state = world.m_8055_(checkPos);
                if (!(dx == 0 && dz == 0 ? !state.m_60795_() : !state.m_204336_(LTCTags.WILD_PEPPERS))) continue;
                return false;
            }
        }
        return true;
    }

    private static void afterTransmutating(Level world, BlockPos pos, boolean isSuccessful) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (isSuccessful) {
                serverWorld.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, new Random().nextFloat() + 0.8f);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.01);
            } else {
                serverWorld.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12031_, SoundSource.PLAYERS, 0.5f, new Random().nextFloat() + 0.8f);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.01);
            }
        }
    }

    private static void createExp(ServerLevel level, Vec3 position, float value) {
        RandomSource random = level.m_213780_();
        float f1 = LTCMathHelper.dpf_s(value);
        int f2 = (int)value;
        f2 = f1 + random.m_188501_() <= 0.8f ? ++f2 : (f2 += 2);
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)f2);
    }
}

