/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.item;

import com.doggystudio.chirencqr.ltc.server.api.IRelicItem;
import com.doggystudio.chirencqr.ltc.server.config.CommonConfig;
import com.doggystudio.chirencqr.ltc.server.item.ItemLatiaoBase;
import com.doggystudio.chirencqr.ltc.server.misc.EnumLatiaoGrade;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEnchantments;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchanterLatiaoItem
extends ItemLatiaoBase
implements IRelicItem {
    public static final FoodProperties ENCHANTER_LATIAO = new FoodProperties.Builder().m_38760_(2).m_38758_(0.25f).effect(() -> new MobEffectInstance(MobEffects.f_19613_, 1200, 0), 1.0f).m_38757_().m_38765_().m_38767_();

    public EnchanterLatiaoItem() {
        super(ENCHANTER_LATIAO);
        this.setGrade(EnumLatiaoGrade.RELICACY);
        this.isTooltipInvisible();
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        super.m_5922_(stack, level, entity);
        Player player = (Player)entity;
        this.giveEnchantedBooks(player, (Integer)CommonConfig.MAX_COUNT_ENCHANTER_BOOK.get());
        return stack;
    }

    private void giveEnchantedBooks(Player player, int amount) {
        ArrayList<Enchantment> allEnchantments = new ArrayList<Enchantment>(ForgeRegistries.ENCHANTMENTS.getValues());
        allEnchantments.removeIf(e -> e.m_6589_() || e == LTCEnchantments.LATIAO_MENDING.get());
        amount = Math.min(amount, allEnchantments.size());
        Collections.shuffle(allEnchantments);
        int count = Math.min(amount, allEnchantments.size());
        for (int i = 0; i < count; ++i) {
            Enchantment enchantment = i == 0 ? (Enchantment)LTCEnchantments.LATIAO_MENDING.get() : (Enchantment)allEnchantments.get(i);
            RandomSource random = player.m_9236_().m_213780_();
            int maxLevel = enchantment.m_6586_();
            int randomLevel = random.m_188503_(maxLevel) + 1;
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            this.addRelicTag(book);
            book.m_41714_((Component)Component.m_237115_((String)"item.ltc2.enchanter_book").m_130938_(EnumLatiaoGrade.getStyleByLatiaoGrade(6)));
            if (((Boolean)CommonConfig.ENCHANTER_BOOK_LEVEL.get()).booleanValue()) {
                EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, maxLevel));
            } else {
                EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, randomLevel));
            }
            if (player.m_36356_(book)) continue;
            player.m_36176_(book, false);
        }
    }
}

