/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.item;

import com.doggystudio.chirencqr.ltc.client.particle.LTCParticles;
import com.doggystudio.chirencqr.ltc.server.LatiaoCraft;
import com.doggystudio.chirencqr.ltc.server.config.CommonConfig;
import com.doggystudio.chirencqr.ltc.server.registry.LTCDamageTypes;
import com.doggystudio.chirencqr.ltc.server.registry.LTCEffects;
import com.doggystudio.chirencqr.ltc.server.registry.LTCSounds;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTiers;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EvilSwordItem
extends SwordItem {
    public EvilSwordItem() {
        super((Tier)LTCTiers.EVIL, 3, -2.4f, new Item.Properties().m_41497_(LatiaoCraft.LTC_RELICACY).m_41486_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (stack == player.m_6844_(EquipmentSlot.MAINHAND)) {
                CompoundTag tag;
                tag.m_128379_("destroy", !(tag = stack.m_41784_()).m_128471_("destroy"));
                player.m_6674_(hand);
                if (!player.m_9236_().f_46443_) {
                    LTCTriggers.EVIL_SWORD.trigger((ServerPlayer)player);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        } else if (!level.f_46443_ && ((Boolean)CommonConfig.EVIL_SWOLD_SKILL.get()).booleanValue()) {
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_((Item)this, 300);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            this.circle(level, player, 3.5);
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)LTCSounds.EVIL_SWORD_SKILL.get(), SoundSource.PLAYERS, 0.5f, 0.0f);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity enemy, LivingEntity attacker) {
        Player player = (Player)attacker;
        float exDamage = 0.0f;
        if (stack.m_41783_() != null) {
            if (stack.m_41783_().m_128471_("destroy")) {
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                enemy.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 200, 0));
                stack.m_41622_(3, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                if (enemy.m_21023_((MobEffect)LTCEffects.HOT.get())) {
                    exDamage += 4.0f;
                }
                enemy.m_6469_(LTCDamageTypes.getDamageSource(player.m_9236_(), LTCDamageTypes.HOT), 2.0f + exDamage);
            } else {
                stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                if (enemy.m_21023_((MobEffect)LTCEffects.HOT.get())) {
                    exDamage += 2.0f;
                }
                enemy.m_6469_(LTCDamageTypes.getDamageSource(player.m_9236_(), LTCDamageTypes.HOT), exDamage);
            }
        }
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        if (stack.m_41783_().m_128471_("destroy")) {
            list.add((Component)Component.m_237115_((String)"tooltip.ltc2.evil_sword_destroy").m_130940_(ChatFormatting.DARK_RED));
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.ltc2.evil_sword").m_130940_(ChatFormatting.WHITE));
        }
    }

    private void circle(Level level, Player player, double r) {
        double x = player.m_20185_();
        double y = player.m_20186_() + 0.5;
        double z = player.m_20189_();
        this.circleCalculate(level, x, y, z, r, 1);
        this.circleCalculate(level, x, y, z, r -= 1.5, 5);
        this.circleCalculate(level, x, y, z, r -= 1.5, 10);
        this.circleEffect(level, player, x, y + 0.5, z, 3.5);
    }

    private void circleEffect(Level level, Player player, double x, double y, double z, double r) {
        AABB area = new AABB(x - (r += 0.25), y - r, z - r, x + r, y + r, z + r);
        for (Entity entity : level.m_45976_(LivingEntity.class, area)) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity) == player) continue;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)LTCEffects.HOT.get(), 200, 1));
        }
    }

    private void circleCalculate(Level level, double x, double y, double z, double r, int pointDenominator) {
        int points = 360 / pointDenominator;
        double angleStep = Math.PI * 2 / (double)points;
        for (int i = 0; i < points; ++i) {
            double angle = (double)i * angleStep;
            double px = x + r * Math.cos(angle);
            double pz = z + r * Math.sin(angle);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)LTCParticles.EVIL_FLAME.get()), px, y, pz, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }
}

