/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.item;

import com.doggystudio.chirencqr.ltc.server.LatiaoCraft;
import com.doggystudio.chirencqr.ltc.server.api.ILatiaoClub;
import com.doggystudio.chirencqr.ltc.server.api.ILatiaoGrade;
import com.doggystudio.chirencqr.ltc.server.api.ILegendaryFeastLatiao;
import com.doggystudio.chirencqr.ltc.server.crafting.ExtraSpiceCustomRecipe;
import com.doggystudio.chirencqr.ltc.server.misc.EnumLatiaoGrade;
import com.doggystudio.chirencqr.ltc.server.misc.LTCColorHelper;
import com.doggystudio.chirencqr.ltc.server.misc.SecondaryFlavour;
import com.doggystudio.chirencqr.ltc.server.misc.SecondaryFlavourRegistry;
import com.doggystudio.chirencqr.ltc.server.registry.LTCItems;
import com.doggystudio.chirencqr.ltc.server.registry.LTCSecondaryFlavours;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTags;
import com.doggystudio.chirencqr.ltc.server.registry.LTCTriggers;
import com.doggystudio.chirencqr.ltc.server.spiceevent.AbstractSpiceEvent;
import com.doggystudio.chirencqr.ltc.server.spiceevent.SpiceEventRegistry;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemLatiaoBase
extends Item
implements ILatiaoGrade {
    private int effectTime = 0;
    private int effectLevel = 0;
    private int afterFlavouringEffectLevel = 0;
    private boolean isNetheriteLatiao = false;
    private boolean canLegendary = false;
    private boolean isEnchanted = false;
    private boolean isWeapon = false;
    private boolean isTooltipInvisible = false;
    private boolean isBasicLatiao = false;
    private int burningTime = 0;
    private static final List<Item> CAN_LEGENDARY_LIST = new ArrayList<Item>();
    private List<MobEffect> ltEffects = Lists.newArrayList();
    protected EnumLatiaoGrade grade;
    private Map<Integer, Integer> mapEffectDuration = new HashMap<Integer, Integer>();
    private UnaryOperator<Style> COLOR_MODERATE = LTCColorHelper.createColorTransition(16767673, 14329120, 1800);

    public ItemLatiaoBase(int nutrition, float saturation, int effectTime, int effectLevel, EnumLatiaoGrade grade) {
        super(new Item.Properties().m_41487_(64).m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38757_().m_38765_().m_38767_()));
        this.effectTime = effectTime;
        this.effectLevel = effectLevel;
        this.grade = grade;
    }

    public ItemLatiaoBase(int nutrition, float saturation, EnumLatiaoGrade grade) {
        super(new Item.Properties().m_41487_(64).m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38757_().m_38765_().m_38767_()));
        this.grade = grade;
    }

    public ItemLatiaoBase(int nutrition, float saturation, EnumLatiaoGrade grade, boolean isBasicLatiao) {
        super(new Item.Properties().m_41487_(64).m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38757_().m_38765_().m_38767_()));
        this.grade = grade;
        this.isBasicLatiao = isBasicLatiao;
    }

    public ItemLatiaoBase(FoodProperties foodProperties) {
        super(new Item.Properties().m_41487_(64).m_41489_(foodProperties));
    }

    protected ItemLatiaoBase(Item.Properties properties, EnumLatiaoGrade grade) {
        super(properties);
        this.grade = grade;
        this.isWeapon();
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (tag.m_128441_("ltc2.ex_spice") || tag.m_128441_("ltc2.ex_spice2")) && !this.grade.isTreasure()) {
            String spice = tag.m_128461_("ltc2.ex_spice");
            String spice2 = tag.m_128461_("ltc2.ex_spice2");
            return spice.equals(Items.f_42612_.m_5524_()) || spice2.equals(Items.f_42612_.m_5524_());
        }
        if (this.grade.isTreasure()) {
            this.isEnchanted = true;
        }
        return this.isEnchanted;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        int width = 0;
        CompoundTag tag = stack.m_41783_();
        int sweet = tag.m_128451_("ltc2.sweet");
        int salted = tag.m_128451_("ltc2.salted");
        if (sweet > 1 && salted > 1) {
            width = 11;
        }
        return width;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burningTime;
    }

    public ItemLatiaoBase isEnchanted() {
        this.isEnchanted = true;
        return this;
    }

    public ItemLatiaoBase canUpgradeLegendary() {
        if (this.getGrade() == EnumLatiaoGrade.TREASURE) {
            CAN_LEGENDARY_LIST.add(this);
            this.canLegendary = true;
        }
        return this;
    }

    public static List<Item> getCanLegendaryList() {
        return Collections.unmodifiableList(CAN_LEGENDARY_LIST);
    }

    public boolean hasLegendaryGrade() {
        return this.canLegendary;
    }

    public ItemLatiaoBase isNetheriteLatiao() {
        this.isNetheriteLatiao = true;
        return this;
    }

    public void isWeapon() {
        if (this instanceof ILatiaoClub) {
            this.isWeapon = true;
        }
    }

    public ItemLatiaoBase canBurning(int burningTime) {
        this.burningTime = burningTime;
        return this;
    }

    public boolean m_41475_() {
        return this.isNetheriteLatiao;
    }

    public ItemLatiaoBase addLTEffect(MobEffect effect) {
        this.ltEffects.add(effect);
        return this;
    }

    public ItemLatiaoBase isTooltipInvisible() {
        this.isTooltipInvisible = true;
        return this;
    }

    public int getEffectTime() {
        return this.effectTime;
    }

    public void setEffectTime(int effectTime) {
        this.effectTime = effectTime;
    }

    @Override
    public void setGrade(EnumLatiaoGrade grade) {
        this.grade = grade;
    }

    @Override
    public EnumLatiaoGrade getGrade() {
        return this.grade;
    }

    public Rarity m_41460_(ItemStack stack) {
        switch (this.grade.getLatiaoGradeValue()) {
            case 2: {
                return Rarity.UNCOMMON;
            }
            case 3: {
                return Rarity.RARE;
            }
            case 4: {
                return Rarity.EPIC;
            }
            case 5: {
                return LatiaoCraft.LTC_TREASURE;
            }
            case 6: {
                return LatiaoCraft.LTC_RELICACY;
            }
        }
        return Rarity.COMMON;
    }

    public int m_8105_(ItemStack stack) {
        int grade = this.grade.getLatiaoGradeValue();
        if (grade == 4) {
            return 24;
        }
        if (grade == 5) {
            return 16;
        }
        return 32;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        boolean l_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        boolean r_shift = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
        if (this instanceof ILegendaryFeastLatiao || this.isLegendaryGrade(stack)) {
            components.add((Component)Component.m_237115_((String)"tooltip.ltc2.latiao_grade").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)LTCColorHelper.makeColorFont(I18n.m_118938_((String)"tooltip.ltc2.latiao_grade_legendary_feast", (Object[])new Object[0])))));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.ltc2.latiao_grade").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("tooltip.ltc2.latiao_grade_" + this.getLatiaoGradeValue(stack))).m_130938_(EnumLatiaoGrade.getStyleByLatiaoGrade(this.getLatiaoGradeValue(stack)))));
        }
        if (!this.isWeapon) {
            FoodProperties foodStats = stack.m_41720_().m_41473_();
            List elist = foodStats.m_38749_();
            ArrayList mobEffectInstanceList = Lists.newArrayList();
            for (Pair ePair : elist) {
                mobEffectInstanceList.add((MobEffectInstance)ePair.getFirst());
            }
            if (elist.isEmpty()) {
                this.isTooltipInvisible = true;
            }
            if (!this.isTooltipInvisible) {
                PotionUtils.m_257410_((List)mobEffectInstanceList, components, (float)1.0f);
            }
        }
        if (stack.m_204117_(LTCTags.F_LATIAO)) {
            if (stack.m_41782_()) {
                CompoundTag tag = stack.m_41783_();
                int sweet = tag.m_128451_("ltc2.sweet");
                int salted = tag.m_128451_("ltc2.salted");
                String f2 = tag.m_128461_("ltc2.secondary_flavour");
                MutableComponent flavourComponent = null;
                if (sweet > 0 || salted > 0 || !f2.isEmpty()) {
                    flavourComponent = Component.m_237115_((String)"tooltip.ltc2.flavour").m_130940_(ChatFormatting.LIGHT_PURPLE);
                    MutableComponent flavourText = null;
                    if (sweet > 0 && salted == sweet) {
                        flavourText = Component.m_237113_((String)I18n.m_118938_((String)("tooltip.ltc2.flavour.moderate_" + salted), (Object[])new Object[0])).m_130938_(this.COLOR_MODERATE);
                    } else if (sweet > 0 && salted == 0) {
                        flavourText = Component.m_237115_((String)(sweet < 2 ? "tooltip.ltc2.flavour.sweet" : "tooltip.ltc2.flavour.sugary")).m_130940_(ChatFormatting.WHITE);
                    } else if (salted > 0 && sweet == 0) {
                        flavourText = Component.m_237115_((String)(salted < 2 ? "tooltip.ltc2.flavour.salted" : "tooltip.ltc2.flavour.salty")).m_130940_(ChatFormatting.WHITE);
                    } else if (sweet > 1 && salted == 1) {
                        flavourText = Component.m_237115_((String)"tooltip.ltc2.flavour.sugary_salted").m_130940_(ChatFormatting.WHITE);
                    } else if (salted > 1 && sweet == 1) {
                        flavourText = Component.m_237115_((String)"tooltip.ltc2.flavour.salty_sweet").m_130940_(ChatFormatting.WHITE);
                    }
                    if (flavourText != null) {
                        flavourComponent = flavourComponent.m_7220_((Component)flavourText);
                    }
                    if (!f2.isEmpty()) {
                        for (SecondaryFlavour f2f : SecondaryFlavourRegistry.getREGISTRIES()) {
                            if (!f2f.getRegistryName().equals(f2)) continue;
                            MutableComponent f2Component = Component.m_237115_((String)("tooltip.ltc2.flavour." + f2f.getRegistryName())).m_130938_(f2f.getStyleModifier());
                            if (flavourText == null) {
                                flavourComponent = flavourComponent.m_7220_((Component)f2Component);
                                break;
                            }
                            flavourComponent = flavourComponent.m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)f2Component);
                            break;
                        }
                    }
                    components.add((Component)flavourComponent);
                }
                String spice1 = tag.m_128461_("ltc2.ex_spice");
                String spice2 = tag.m_128461_("ltc2.ex_spice2");
                if (!spice1.isEmpty() && spice2.isEmpty()) {
                    components.add((Component)Component.m_237115_((String)"tooltip.ltc2.extra").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)spice1).m_130940_(ChatFormatting.WHITE)));
                } else if (!spice1.isEmpty() || !spice2.isEmpty()) {
                    components.add((Component)Component.m_237115_((String)"tooltip.ltc2.extra").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)spice1).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)"gui.ltc2.extra_spice.comma").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)spice2).m_130940_(ChatFormatting.WHITE)));
                }
            } else if (l_shift || r_shift) {
                components.add((Component)Component.m_237115_((String)"tooltip.ltc2.flavour.flavourable").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
            }
        } else if (l_shift || r_shift) {
            components.add((Component)Component.m_237115_((String)"tooltip.ltc2.flavour.unflavourable").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.UNDERLINE));
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (tag.m_128441_("ltc2.ex_spice") || tag.m_128441_("ltc2.ex_spice2"))) {
            String spice = tag.m_128461_("ltc2.ex_spice");
            String spice2 = tag.m_128461_("ltc2.ex_spice2");
            if (spice.equals(Items.f_42735_.m_5524_()) || spice2.equals(Items.f_42735_.m_5524_())) {
                return Component.m_237115_((String)"tooltip.ltc2.brand.weloong").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.m_5671_(stack)));
            }
            if (spice.equals(((Item)LTCItems.VOLCANIC_MUSTARD.get()).m_5524_()) || spice2.equals(((Item)LTCItems.VOLCANIC_MUSTARD.get()).m_5524_())) {
                return Component.m_237115_((String)"tooltip.ltc2.brand.yufong").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.m_5671_(stack)));
            }
            return Component.m_237115_((String)this.m_5671_(stack));
        }
        return super.m_7626_(stack);
    }

    private void mapEffectDurationSet() {
        this.mapEffectDuration.put(1, 1800);
        this.mapEffectDuration.put(2, 3600);
        this.mapEffectDuration.put(3, 7200);
        this.mapEffectDuration.put(4, 12000);
        this.mapEffectDuration.put(5, 18000);
        this.mapEffectDuration.put(6, 24000);
        this.mapEffectDuration.put(7, 36000);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        this.mapEffectDurationSet();
        int EffectTime = this.effectTime;
        int EffectLevel = this.effectLevel;
        EffectTime = this.isBasicLatiao ? (EffectTime += 6000 * (this.getLatiaoGradeValue(stack) - 3)) : (EffectTime += this.mapEffectDuration.get(this.getLatiaoGradeValue(stack)).intValue());
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            LTCTriggers.LATIAO.trigger(player);
            if (this.getLatiaoGradeValue(stack) == 4) {
                LTCTriggers.DELICACY_LATIAO.trigger(player);
            }
            if (this.isLegendaryGrade(stack) || stack.m_41720_() instanceof ILegendaryFeastLatiao) {
                LTCTriggers.LEGENDARY_LATIAO.trigger(player);
            }
            CompoundTag tag = stack.m_41783_();
            if (stack.m_41782_()) {
                int salted;
                int sweet = tag.m_128451_("ltc2.sweet");
                if (sweet > 0) {
                    EffectTime += 600 * this.getLatiaoGradeValue(stack) * sweet;
                }
                if ((salted = tag.m_128451_("ltc2.salted")) > 0) {
                    EffectLevel += 1 * salted;
                }
                if (sweet == 2 && salted == 2) {
                    LTCTriggers.FLAVOURED_LATIAO.trigger(player);
                }
                List<MobEffect> list = this.ltEffects;
                this.effectsAddition((Player)player, list, EffectTime, EffectLevel);
                String spice = tag.m_128461_("ltc2.ex_spice");
                String spice2 = tag.m_128461_("ltc2.ex_spice2");
                boolean flag = true;
                this.spiceEventAttach(stack, spice, level, living, flag);
                flag = true;
                this.spiceEventAttach(stack, spice2, level, living, flag);
            } else {
                List<MobEffect> list = this.ltEffects;
                this.effectsAddition((Player)player, list, EffectTime, EffectLevel);
            }
            this.afterFlavouringEffectLevel = EffectLevel;
        }
        super.m_5922_(stack, level, living);
        return stack;
    }

    private void spiceEventAttach(ItemStack stack, String spice, Level level, LivingEntity living, boolean flag) {
        flag = false;
        Player player = (Player)living;
        CompoundTag tag = stack.m_41784_();
        int grade = this.getLatiaoGradeValue(stack);
        int grd = SecondaryFlavour.isAlive(stack, LTCSecondaryFlavours.LIME) ? grade + 1 : grade;
        RecipeManager recipeManager = level.m_7465_();
        Collection recipes = recipeManager.m_44051_();
        recipes.stream().filter(recipe -> recipe instanceof ExtraSpiceCustomRecipe).map(recipe -> (ExtraSpiceCustomRecipe)recipe).forEach(extraSpiceRecipe -> {
            if (spice.equals(extraSpiceRecipe.getItem().m_41778_())) {
                System.out.println("\u89e6\u53d1 Spice: " + spice);
                for (String eventKey : extraSpiceRecipe.getEvents()) {
                    AbstractSpiceEvent event = SpiceEventRegistry.get(eventKey);
                    if (event != null) {
                        event.drive(stack, level, (LivingEntity)player, this.ltEffects, grd, this.afterFlavouringEffectLevel);
                        continue;
                    }
                    System.out.println("Not found SpiceEvent: " + eventKey);
                }
            }
        });
    }

    private void effectsAddition(Player player, List<MobEffect> list, int EffectTime, int EffectLevel) {
        for (MobEffect effect : list) {
            MobEffectInstance effectInstance = new MobEffectInstance(effect, EffectTime, EffectLevel);
            player.m_7292_(effectInstance);
        }
    }

    public int getLatiaoGradeValue(ItemStack stack) {
        if (stack.m_41720_() instanceof ILegendaryFeastLatiao) {
            return 6;
        }
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("LatiaoGradeValue")) {
                return stack.m_41783_().m_128451_("LatiaoGradeValue");
            }
            return stack.m_41783_().m_128471_("legendary") ? 6 : this.getGrade().getLatiaoGradeValue();
        }
        return this.getGrade().getLatiaoGradeValue();
    }

    public static void setLegendary(ItemStack stack) {
        stack.m_41784_().m_128379_("legendary", true);
    }

    public boolean isLegendaryGrade(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("legendary");
    }
}

