/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.item;

import com.doggystudio.chirencqr.ltc.server.api.IPepperCrop;
import com.doggystudio.chirencqr.ltc.server.config.CommonConfig;
import com.doggystudio.chirencqr.ltc.server.registry.LTCBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PepperFertilizerItem
extends Item {
    private static int genCount = 0;

    public PepperFertilizerItem() {
        super(new Item.Properties().m_41487_(64));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        RandomSource random = level.m_213780_();
        this.growPepperCrop(level, pos, context.m_43722_(), context.m_43723_());
        if (!level.f_46443_ && (this.canUseFertilizerOnOverworld(blockState) || this.canUseFertilizerOnNether(blockState) || this.canUseFertilizerOnEnd(blockState))) {
            this.generatePepper(level, random, pos, false);
            if (genCount < (Integer)CommonConfig.MIN_COUNT_FERTILIZER_PEPPER_GEN.get()) {
                this.generatePepper(level, random, pos, true);
            }
            genCount = 0;
            if (!context.m_43723_().m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
        }
        if (level.f_46443_ && (this.canUseFertilizerOnOverworld(blockState) || this.canUseFertilizerOnNether(blockState) || this.canUseFertilizerOnEnd(blockState))) {
            PepperFertilizerItem.addGrowthParticles((LevelAccessor)level, pos, 15);
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_144074_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void generatePepper(Level level, RandomSource random, BlockPos pos, boolean isFallBack) {
        Random rand = new Random(level.m_46467_() - level.m_46468_() * 2L);
        for (int[] offset : this.getShuffledOffsets(rand)) {
            BlockPos setPos = pos.m_7494_().m_7918_(offset[0], offset[1], offset[2]);
            BlockPos belowSetPos = pos.m_7918_(offset[0], offset[1], offset[2]);
            BlockState belowPosBlockState = level.m_8055_(belowSetPos);
            if (!isFallBack && (double)random.m_188501_() < (Double)CommonConfig.FERTILIZER_PEPPER_GEN_CHANCE.get()) {
                this.doGen(level, random, belowPosBlockState, setPos);
            } else if (isFallBack) {
                this.doGen(level, random, belowPosBlockState, setPos);
            }
            if ((isFallBack || genCount != (Integer)CommonConfig.MAX_COUNT_FERTILIZER_PEPPER_GEN.get()) && (!isFallBack || genCount != (Integer)CommonConfig.MIN_COUNT_FERTILIZER_PEPPER_GEN.get())) continue;
            break;
        }
    }

    private void doGen(Level level, RandomSource random, BlockState belowPosBlockState, BlockPos setPos) {
        BlockState setPosBlockState = level.m_8055_(setPos);
        if (this.canUseFertilizerOnOverworld(belowPosBlockState)) {
            if (setPosBlockState.m_60795_()) {
                level.m_46597_(setPos, this.getOverworldPepper(random));
                ++genCount;
            } else {
                this.tryGen(level, setPosBlockState, setPos, random);
            }
        }
        if (belowPosBlockState.m_60713_(Blocks.f_50136_) || belowPosBlockState.m_60713_(Blocks.f_50135_)) {
            if (setPosBlockState.m_60795_()) {
                level.m_46597_(setPos, this.getNetherPepper(random));
                ++genCount;
            } else {
                this.tryGen(level, setPosBlockState, setPos, random);
            }
        }
        if (belowPosBlockState.m_60713_(Blocks.f_50259_)) {
            if (setPosBlockState.m_60795_()) {
                level.m_46597_(setPos, this.getEndPepper(random));
                ++genCount;
            } else {
                this.tryGen(level, setPosBlockState, setPos, random);
            }
        }
        if (belowPosBlockState.m_60713_(Blocks.f_50699_)) {
            if (setPosBlockState.m_60795_()) {
                level.m_46597_(setPos, ((Block)LTCBlocks.WILD_PEPPER_BLOODY.get()).m_49966_());
                ++genCount;
            } else {
                this.tryGen(level, setPosBlockState, setPos, random);
            }
        }
        if (belowPosBlockState.m_60713_(Blocks.f_50690_)) {
            if (setPosBlockState.m_60795_()) {
                level.m_46597_(setPos, ((Block)LTCBlocks.WILD_PEPPER_COMPLAINED.get()).m_49966_());
                ++genCount;
            } else {
                this.tryGen(level, setPosBlockState, setPos, random);
            }
        }
    }

    private void tryGen(Level level, BlockState state, BlockPos pos, RandomSource random) {
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            if (this.canUseFertilizerOnOverworld(state)) {
                level.m_46597_(pos.m_7494_(), this.getOverworldPepper(random));
                ++genCount;
            } else if (state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50135_)) {
                level.m_46597_(pos.m_7494_(), this.getNetherPepper(random));
                ++genCount;
            } else if (state.m_60713_(Blocks.f_50699_)) {
                level.m_46597_(pos.m_7494_(), ((Block)LTCBlocks.WILD_PEPPER_BLOODY.get()).m_49966_());
                ++genCount;
            } else if (state.m_60713_(Blocks.f_50690_)) {
                level.m_46597_(pos.m_7494_(), ((Block)LTCBlocks.WILD_PEPPER_COMPLAINED.get()).m_49966_());
                ++genCount;
            } else if (this.canUseFertilizerOnEnd(state)) {
                level.m_46597_(pos.m_7494_(), this.getEndPepper(random));
                ++genCount;
            }
        }
    }

    private static void addGrowthParticles(LevelAccessor level, BlockPos pos, int count) {
        BlockState blockState;
        if (count == 0) {
            count = 15;
        }
        if (!(blockState = level.m_8055_(pos)).m_60795_()) {
            double rangeY;
            double rangeXZ = 0.5;
            if (blockState.m_60804_((BlockGetter)level, pos)) {
                pos = pos.m_7494_();
                count *= 3;
                rangeXZ = 3.0;
                rangeY = 1.0;
            } else {
                rangeY = blockState.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            RandomSource random = level.m_213780_();
            for (int i = 0; i < count; ++i) {
                double pz;
                double py;
                double motionX = random.m_188583_() * 0.02;
                double motionY = random.m_188583_() * 0.02;
                double motionZ = random.m_188583_() * 0.02;
                double offset = 0.5 - rangeXZ;
                double px = (double)pos.m_123341_() + offset + random.m_188500_() * rangeXZ * 2.0;
                if (level.m_8055_(BlockPos.m_274561_((double)px, (double)(py = (double)pos.m_123342_() + random.m_188500_() * rangeY), (double)(pz = (double)pos.m_123343_() + offset + random.m_188500_() * rangeXZ * 2.0)).m_7495_()).m_60795_()) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, px, py, pz, motionX, motionY, motionZ);
            }
        }
    }

    private void growPepperCrop(Level level, BlockPos clickPos, ItemStack stack, Player player) {
        IPepperCrop pepper;
        CropBlock crop;
        BlockState state = level.m_8055_(clickPos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (crop = (CropBlock)block) instanceof IPepperCrop && !(pepper = (IPepperCrop)crop).isHarvest(state)) {
            int maxAge = crop.m_7419_();
            BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(maxAge));
            level.m_7731_(clickPos, newState, 2);
            if (level.f_46443_) {
                PepperFertilizerItem.addGrowthParticles((LevelAccessor)level, clickPos, 15);
                level.m_7785_((double)clickPos.m_123341_(), (double)clickPos.m_123342_(), (double)clickPos.m_123343_(), SoundEvents.f_144074_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
    }

    private BlockState getOverworldPepper(RandomSource random) {
        List<Block> peppers = List.of((Block)LTCBlocks.WILD_PEPPER_GREEN.get(), (Block)LTCBlocks.WILD_PEPPER_WHITE.get(), (Block)LTCBlocks.WILD_PEPPER_SWEET.get(), (Block)LTCBlocks.WILD_PEPPER_FROST.get(), (Block)LTCBlocks.WILD_PEPPER_RED.get());
        return peppers.get(random.m_188503_(peppers.size())).m_49966_();
    }

    private BlockState getNetherPepper(RandomSource random) {
        List<Block> peppers = List.of((Block)LTCBlocks.WILD_PEPPER_JOLOKIA.get(), (Block)LTCBlocks.WILD_PEPPER_BLOODY.get(), (Block)LTCBlocks.WILD_PEPPER_COMPLAINED.get());
        return peppers.get(random.m_188503_(peppers.size())).m_49966_();
    }

    private BlockState getEndPepper(RandomSource random) {
        List<Block> peppers = List.of((Block)LTCBlocks.WILD_PEPPER_UMBRVOL.get(), (Block)LTCBlocks.WILD_PEPPER_ENDBOND.get());
        return peppers.get(random.m_188503_(peppers.size())).m_49966_();
    }

    private List<int[]> getShuffledOffsets(Random random) {
        int[][] offsets = new int[][]{{-2, 0, -2}, {-1, 0, -2}, {0, 0, -2}, {1, 0, -2}, {2, 0, -2}, {-2, 0, -1}, {-1, 0, -1}, {0, 0, -1}, {1, 0, -1}, {2, 0, -1}, {-2, 0, 0}, {-1, 0, 0}, {0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {-2, 0, 1}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {2, 0, 1}, {-2, 0, 2}, {-1, 0, 2}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}};
        ArrayList<int[]> shuffledOffsets = new ArrayList<int[]>(Arrays.asList(offsets));
        Collections.shuffle(shuffledOffsets, random);
        return shuffledOffsets;
    }

    private boolean canUseFertilizerOnOverworld(BlockState state) {
        return state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_);
    }

    private boolean canUseFertilizerOnNether(BlockState state) {
        return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_(Blocks.f_50699_) || state.m_60713_(Blocks.f_50690_);
    }

    private boolean canUseFertilizerOnEnd(BlockState state) {
        return state.m_60713_(Blocks.f_50259_) || state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_);
    }
}

