/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.misc;

import com.doggystudio.chirencqr.ltc.client.ClientProxy;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public enum EnumLatiaoGrade {
    ORDINARY(1, "ordinary", ChatFormatting.WHITE),
    RARE(2, "rare", ChatFormatting.YELLOW),
    SUPERIOR(3, "superior", ChatFormatting.AQUA),
    DELICACY(4, "delicacy", ChatFormatting.LIGHT_PURPLE),
    TREASURE(5, "treasure", ChatFormatting.GOLD),
    RELICACY(6, "relicacy", style -> {
        float time = (float)(System.currentTimeMillis() % 2500L) / 2500.0f;
        float t = (float)(0.5 * (1.0 + Math.sin((double)time * Math.PI * 2.0)));
        int r = 255;
        int g = (int)(85.0f + -65.0f * t);
        int b = (int)(85.0f + 25.0f * t);
        return style.m_178520_(r << 16 | g << 8 | b);
    });

    private final int value;
    private final String name;
    private ChatFormatting color;
    private final UnaryOperator<Style> styleModifier;

    private EnumLatiaoGrade(int value, String name, ChatFormatting color) {
        this.value = value;
        this.name = name;
        this.color = color;
        this.styleModifier = style -> style.m_131140_(color);
    }

    private EnumLatiaoGrade(int value, String name, UnaryOperator<Style> styleModifier) {
        this.value = value;
        this.name = name;
        this.styleModifier = styleModifier;
    }

    public int getLatiaoGradeValue() {
        return this.value;
    }

    public String getLatiaoGradeName() {
        return this.name;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public UnaryOperator<Style> getStyle() {
        return this.getLatiaoGradeValue() == 6 ? this.styleModifier : style -> style.m_131140_(this.color);
    }

    public boolean isTreasure() {
        return this.value >= 5;
    }

    public static ChatFormatting getColorByLatiaoGrade(int latiaoGrade) {
        for (EnumLatiaoGrade grade : EnumLatiaoGrade.values()) {
            if (grade.getLatiaoGradeValue() != latiaoGrade) continue;
            return grade.getColor();
        }
        return ChatFormatting.WHITE;
    }

    public static UnaryOperator<Style> getStyleByLatiaoGrade(int latiaoGrade) {
        if (latiaoGrade == 7) {
            return style -> style.m_178520_(ClientProxy.getDynamicColor(1500.0));
        }
        for (EnumLatiaoGrade grade : EnumLatiaoGrade.values()) {
            int value = grade.getLatiaoGradeValue();
            if (value != latiaoGrade) continue;
            if (value != 6) {
                return style -> style.m_131140_(grade.getColor());
            }
            return grade.getStyle();
        }
        return style -> style.m_131140_(ChatFormatting.WHITE);
    }
}

