/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.misc;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Style;

public class LTCColorHelper {
    private static final ChatFormatting[] RAINBOW = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.DARK_GRAY, ChatFormatting.DARK_PURPLE, ChatFormatting.BLUE, ChatFormatting.DARK_BLUE, ChatFormatting.DARK_AQUA, ChatFormatting.GREEN, ChatFormatting.DARK_GREEN, ChatFormatting.YELLOW, ChatFormatting.GOLD, ChatFormatting.RED, ChatFormatting.DARK_RED, ChatFormatting.DARK_GRAY};

    public static UnaryOperator<Style> createColorTransition(int startColor, int endColor, int periodMillis) {
        return style -> {
            float time = (float)(System.currentTimeMillis() % (long)periodMillis) / (float)periodMillis;
            float t = (float)(0.5 * (1.0 + Math.sin((double)time * Math.PI * 2.0)));
            int r1 = startColor >> 16 & 0xFF;
            int g1 = startColor >> 8 & 0xFF;
            int b1 = startColor & 0xFF;
            int r2 = endColor >> 16 & 0xFF;
            int g2 = endColor >> 8 & 0xFF;
            int b2 = endColor & 0xFF;
            int r = (int)((float)r1 + (float)(r2 - r1) * t);
            int g = (int)((float)g1 + (float)(g2 - g1) * t);
            int b = (int)((float)b1 + (float)(b2 - b1) * t);
            int rgb = r << 16 | g << 8 | b;
            return style.m_178520_(rgb);
        };
    }

    public static String colorStringFormatting(String input, ChatFormatting[] colors, double delay, int step, int posStep) {
        if (delay <= 0.0) {
            delay = 0.001;
        }
        StringBuilder sb = new StringBuilder(input.length() * 3);
        long currentTime = Util.m_137550_();
        int offset = (int)Math.floor((double)currentTime / delay) % colors.length;
        for (int i = 0; i < input.length(); i += step) {
            for (int j = 0; j < step && i + j < input.length(); ++j) {
                char c = input.charAt(i + j);
                int colorIndex = ((i + j) * posStep + colors.length - offset) % colors.length;
                sb.append(colors[colorIndex].toString());
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String makeColorFont(String input) {
        return LTCColorHelper.colorStringFormatting(input, RAINBOW, 750 / input.length(), 1, 1);
    }
}

