/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.misc;

import java.util.Random;

public class LTCMathHelper {
    public static float suckingBlood(float maxHP, float currentHP, int level, float damage) {
        float c = (float)(Math.random() * 0.5 + 0.5);
        float levelFactor = Math.max(1, level) + 1;
        return (damage - c) * (levelFactor / (currentHP + 1.0f)) * c;
    }

    public static int expPlunderer(int baseEXP, int effectAmplifier) {
        if (effectAmplifier < 2) {
            baseEXP = baseEXP * (effectAmplifier + 1) + effectAmplifier;
        } else if (effectAmplifier >= 2) {
            baseEXP = baseEXP * (effectAmplifier + 1) + 2 * effectAmplifier;
        } else if (effectAmplifier < 0) {
            throw new IllegalArgumentException("Effect Amplifier should be greater than -1");
        }
        return baseEXP;
    }

    public static boolean drawNumber(int probability) {
        if (probability < 0 || probability > 100) {
            throw new IllegalArgumentException("Probability must be between 0 and 100.");
        }
        Random random = new Random();
        int roll = random.nextInt(100) + 1;
        return roll <= probability;
    }

    public static int calculateDurationBasedOnLatiaoGrade(int baseDuration, int latiaoGrade) {
        return switch (latiaoGrade) {
            case 1 -> baseDuration;
            case 2 -> baseDuration * 2;
            case 3 -> baseDuration * 4;
            case 4 -> (int)((double)baseDuration * 6.666666666666667);
            case 5 -> baseDuration * 10;
            case 6 -> (int)((double)baseDuration * 13.333333333333334);
            case 7 -> baseDuration * 20;
            default -> baseDuration;
        };
    }

    public static double calculateDurationMagnificationBasedOnLatiaoGrade(int latiaoGrade) {
        return switch (latiaoGrade) {
            case 1 -> 1.0;
            case 2 -> 2.0;
            case 3 -> 4.0;
            case 4 -> 6.666666666666667;
            case 5 -> 10.0;
            case 6 -> 13.333333333333334;
            default -> 0.0;
        };
    }

    public static float dpf_s(float f) {
        f -= (float)((int)f);
        return f;
    }

    public static int[] hexToRgb(int hexColor) {
        int r = hexColor >> 16 & 0xFF;
        int g = hexColor >> 8 & 0xFF;
        int b = hexColor & 0xFF;
        return new int[]{r, g, b};
    }
}

