/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ParticleEnderChainPacket {
    private final Vec3 from;
    private final Vec3 to;

    public ParticleEnderChainPacket(Vec3 from, Vec3 to) {
        this.from = from;
        this.to = to;
    }

    public ParticleEnderChainPacket(FriendlyByteBuf buf) {
        this.from = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.to = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.from.f_82479_);
        buf.writeDouble(this.from.f_82480_);
        buf.writeDouble(this.from.f_82481_);
        buf.writeDouble(this.to.f_82479_);
        buf.writeDouble(this.to.f_82480_);
        buf.writeDouble(this.to.f_82481_);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null) {
                Vec3 direction = this.to.m_82546_(this.from).m_82541_();
                double distance = this.from.m_82554_(this.to);
                double step = 0.25;
                int count = (int)(distance / step);
                for (int i = 0; i <= count; ++i) {
                    double progress = (double)i * step;
                    Vec3 pos = this.from.m_82549_(direction.m_82490_(progress));
                    mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, -0.025, 0.0);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

