/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.spiceevent;

import com.doggystudio.chirencqr.ltc.server.crafting.OreifyRecipe;
import com.doggystudio.chirencqr.ltc.server.spiceevent.AbstractSpiceEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class OreifySpiceEvent
extends AbstractSpiceEvent {
    public OreifySpiceEvent(String namespace) {
        super(namespace, "oreify");
    }

    @Override
    public void drive(ItemStack stack, Level level, LivingEntity entity, List<MobEffect> effects, int latiaoGrade, int afterFlavouringEffectLevel) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos belowPlayer = player.m_20183_().m_7495_();
            RecipeManager recipeManager = player.m_9236_().m_7465_();
            Collection recipes = recipeManager.m_44051_();
            recipes.stream().filter(recipe -> recipe instanceof OreifyRecipe).map(recipe -> (OreifyRecipe)recipe).forEach(recipe -> {
                if (recipe.getBaseBlock() != Blocks.f_50016_) {
                    int[][] offsets = new int[][]{{0, 0, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}, {1, 0, 1}, {1, 0, -1}, {-1, 0, 1}, {-1, 0, -1}};
                    int limit = latiaoGrade == 4 ? 5 : (latiaoGrade >= 5 ? 9 : latiaoGrade);
                    for (int i = 0; i < limit; ++i) {
                        int[] offset = offsets[i];
                        BlockPos targetPos = belowPlayer.m_7918_(offset[0], offset[1], offset[2]);
                        BlockState currentState = player.m_9236_().m_8055_(targetPos);
                        if (!currentState.m_60713_(recipe.getBaseBlock())) continue;
                        player.m_9236_().m_46597_(targetPos, this.oreifying(recipe.getOreMap(), recipe.getBaseBlock()).m_49966_());
                        this.soundAndParticle(player, targetPos);
                    }
                }
            });
        }
    }

    private Block oreifying(Map<Block, Integer> map, Block baseBlock) {
        int total = map.values().stream().mapToInt(Integer::intValue).sum();
        Random random = new Random();
        int randomWeight = random.nextInt(total);
        int cumulativeWeight = 0;
        Block block = null;
        for (Map.Entry<Block, Integer> entry : map.entrySet()) {
            if (randomWeight >= (cumulativeWeight += entry.getValue().intValue())) continue;
            block = entry.getKey();
            break;
        }
        return block != null ? block : baseBlock;
    }

    private void soundAndParticle(Player player, BlockPos belowPlayer) {
        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.3f, new Random().nextFloat() + 0.3f);
        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, (double)((float)belowPlayer.m_123341_() + 0.5f), (double)belowPlayer.m_123342_(), (double)((float)belowPlayer.m_123343_() + 0.5f), 1.0, 1.0, 1.0);
    }
}

