/*
 * Decompiled with CFR 0.152.
 */
package com.doggystudio.chirencqr.ltc.server.worldgen.feature;

import com.doggystudio.chirencqr.ltc.server.registry.LTCBlocks;
import com.doggystudio.chirencqr.ltc.server.worldgen.feature.config.WildPepperUmbrvolFeatureConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class WildPepperUmbrvolFeature
extends Feature<WildPepperUmbrvolFeatureConfig> {
    private static final Block WILD_PEPPER_UMBRVOL = (Block)LTCBlocks.WILD_PEPPER_UMBRVOL.get();

    public WildPepperUmbrvolFeature(Codec<WildPepperUmbrvolFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<WildPepperUmbrvolFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        WildPepperUmbrvolFeatureConfig config = (WildPepperUmbrvolFeatureConfig)context.m_159778_();
        boolean placedAny = false;
        for (int i = 0; i < config.tries(); ++i) {
            BlockPos pos = origin.m_7918_(random.m_188503_(config.xzSpread() * 2 + 1) - config.xzSpread(), random.m_188503_(config.ySpread() * 2 + 1) - config.ySpread(), random.m_188503_(config.xzSpread() * 2 + 1) - config.xzSpread());
            boolean nearChorus = this.isNearChorus((LevelAccessor)level, pos, config.radius());
            if (nearChorus && random.m_188501_() < config.nearChorusGenerateProbability()) {
                this.generatePepper((LevelAccessor)level, pos);
                placedAny = true;
                continue;
            }
            if (nearChorus || !(random.m_188501_() < config.farChorusGenerateProbability())) continue;
            this.generatePepper((LevelAccessor)level, pos);
            placedAny = true;
        }
        return placedAny;
    }

    private boolean isNearChorus(LevelAccessor level, BlockPos pos, int radius) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.m_122178_(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz);
                    Block block = level.m_8055_((BlockPos)mutable).m_60734_();
                    if (block != Blocks.f_50491_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void generatePepper(LevelAccessor level, BlockPos pos) {
        if (level.m_46859_(pos) && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50259_)) {
            level.m_7731_(pos, WILD_PEPPER_UMBRVOL.m_49966_(), 2);
        }
    }
}

