/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pmweatherplus.network;

import net.mcreator.pmweatherplus.PmweatherPlusMod;
import net.mcreator.pmweatherplus.procedures.NWSEASTornadoWarningRadarIndicatedTabletProcedure;
import net.mcreator.pmweatherplus.procedures.TornadoWarningToObservedTornadoProcedure;
import net.mcreator.pmweatherplus.procedures.TornadoWarningToPDSTornadoProcedure;
import net.mcreator.pmweatherplus.procedures.TornadoWarningToTornadoEmergencyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record NWSTabletTornadoWarningButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NWSTabletTornadoWarningButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pmweather_plus", (String)"nws_tablet_tornado_warning_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NWSTabletTornadoWarningButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new NWSTabletTornadoWarningButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<NWSTabletTornadoWarningButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(NWSTabletTornadoWarningButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> NWSTabletTornadoWarningButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NWSEASTornadoWarningRadarIndicatedTabletProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            TornadoWarningToObservedTornadoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            TornadoWarningToPDSTornadoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            TornadoWarningToTornadoEmergencyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PmweatherPlusMod.addNetworkMessage(TYPE, STREAM_CODEC, NWSTabletTornadoWarningButtonMessage::handleData);
    }
}

