/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class ISOMobEffectInstance {
    public final Supplier<MobEffect> effect;
    public int duration;
    public int amplifier = 0;
    public boolean ambient = false;
    public boolean visible = true;
    public boolean showIcon = true;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<ISOMobEffectInstance>>(){}.getType();

    public ISOMobEffectInstance(MobEffect effect, int duration) {
        this.effect = () -> effect;
        this.duration = duration;
    }

    public ISOMobEffectInstance(Supplier<MobEffect> effect, int duration) {
        this.effect = effect;
        this.duration = duration;
    }

    public MobEffectInstance getMobEffectInstance() {
        return new MobEffectInstance(this.effect.get(), this.duration, this.amplifier, this.ambient, this.visible, this.showIcon);
    }

    public static class Serializer
    implements JsonDeserializer<ISOMobEffectInstance>,
    JsonSerializer<ISOMobEffectInstance> {
        public ISOMobEffectInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            String id = GsonHelper.m_13851_((JsonObject)jObject, (String)"id", (String)"");
            if (!id.isEmpty() && !ResourceLocation.m_135830_((String)id)) {
                throw new JsonParseException("Invalid id: %s".formatted(id));
            }
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.parse((String)id));
            if (mobEffect == null) {
                throw new JsonParseException("%d is not a known mob_effect".formatted(id));
            }
            int duration = GsonHelper.m_13927_((JsonObject)jObject, (String)"duration");
            Builder builder = new Builder(() -> mobEffect, duration);
            if (jObject.has("amplifier")) {
                builder.setAmplifier(GsonHelper.m_13927_((JsonObject)jObject, (String)"amplifier"));
            }
            if (jObject.has("amplifier")) {
                builder.setAmplifier(GsonHelper.m_13927_((JsonObject)jObject, (String)"amplifier"));
            }
            if (GsonHelper.m_13855_((JsonObject)jObject, (String)"ambient", (boolean)false)) {
                builder.ambientParticles();
            }
            if (GsonHelper.m_13855_((JsonObject)jObject, (String)"hide_particles", (boolean)false)) {
                builder.noParticles();
            }
            if (GsonHelper.m_13855_((JsonObject)jObject, (String)"hide_icon", (boolean)false)) {
                builder.hideIcon();
            }
            return builder.build();
        }

        public JsonElement serialize(ISOMobEffectInstance src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", ForgeRegistries.MOB_EFFECTS.getKey((Object)src.effect.get()).toString());
            jsonObject.addProperty("duration", (Number)src.duration);
            if (src.amplifier > 0) {
                jsonObject.addProperty("amplifier", (Number)src.amplifier);
            }
            if (src.ambient) {
                jsonObject.addProperty("ambient", Boolean.valueOf(true));
            }
            if (!src.visible) {
                jsonObject.addProperty("hide_particles", Boolean.valueOf(true));
            }
            if (!src.showIcon) {
                jsonObject.addProperty("hide_icon", Boolean.valueOf(true));
            }
            return jsonObject;
        }
    }

    public static class Builder {
        public ISOMobEffectInstance mobEffectInstance;

        public Builder(MobEffect effect, int duration) {
            this.mobEffectInstance = new ISOMobEffectInstance(effect, duration);
        }

        public Builder(Supplier<MobEffect> effectSupplier, int duration) {
            this.mobEffectInstance = new ISOMobEffectInstance(effectSupplier, duration);
        }

        public Builder setAmplifier(int amplifier) {
            this.mobEffectInstance.amplifier = amplifier;
            return this;
        }

        public Builder ambientParticles() {
            this.mobEffectInstance.ambient = true;
            return this;
        }

        public Builder noParticles() {
            this.mobEffectInstance.visible = false;
            return this;
        }

        public Builder hideIcon() {
            this.mobEffectInstance.showIcon = false;
            return this;
        }

        public ISOMobEffectInstance build() {
            return this.mobEffectInstance;
        }
    }
}

