/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.iguanatweaksreborn.modifier.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

@JsonAdapter(value=Serializer.class)
public class SeasonModifier
extends Modifier {
    final List<Season> seasons = new ArrayList<Season>();

    protected SeasonModifier(float modifier, Modifier.Operation operation, List<Season> seasons) {
        super(modifier, operation);
        this.seasons.addAll(seasons);
    }

    @Override
    public boolean shouldApply(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        for (Season season : this.seasons) {
            if (!SeasonHelper.getSeasonState((Level)level).getSeason().equals((Object)season)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<SeasonModifier> {
        public SeasonModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ArrayList<Season> seasons = new ArrayList<Season>();
            JsonArray aSeasons = GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"seasons");
            if (aSeasons.isEmpty()) {
                throw new JsonParseException("seasons list must contain at least one entry");
            }
            for (JsonElement jsonElement : aSeasons) {
                Season season = (Season)context.deserialize(jsonElement, Season.class);
                seasons.add(season);
            }
            return new SeasonModifier(GsonHelper.m_13915_((JsonObject)jObject, (String)"modifier"), (Modifier.Operation)((Object)context.deserialize(jObject.get("operation"), Modifier.Operation.class)), seasons);
        }
    }
}

